// Just a simple "wrapper" for mIRC usage of Turbopower's
// Abbrevia component, which is open source and available
// from SourceForge.net

// Enjoy, mc68000 (mc68000@nextgenirc.net)

library zip;

uses
  Windows,
  SysUtils,
  AbArcTyp,
  AbZipper,
  AbUnZper;

function _zip(mWnd, aWnd: HWND; data, params: PChar; show, nopause: boolean):integer; stdcall;
var
  Zip: TAbZipper;
  Msg, Switch, Both, FileName, Path, Target: String;
  Position: Integer;
begin
  Position := Pos('" "', data);
  if Position <> 0 then begin
    Switch := Copy(data, 1, 2);
    Both := Copy(data, 5, Position - 5);
    Path := ExtractFilePath(Both);
    FileName := ExtractFileName(Both);
    Target := Copy(data, Position + 3, Length(data) - (Position + 3));
    Zip := TAbZipper.Create(nil);
    if Switch = '-r' then begin
      Zip.StoreOptions := [soStripDrive, soRemoveDots, soRecurse, soReplace];
    end
    else begin
      Zip.StoreOptions := [soStripDrive, soRemoveDots, soReplace];
    end;
    Zip.BaseDirectory := Path;
    Zip.FileName := Target;
    Zip.AddFiles(FileName, 0);
    Zip.CloseArchive;
    Zip.Destroy;
    Msg := 'OK';
  end
  else begin
    Msg := 'Error';
  end;
  StrCopy(data, PChar(Msg));
  Result := 3;
end;

function _unzip(mWnd, aWnd: HWND; data, params: PChar; show, nopause: boolean):integer; stdcall;
var
  UnZip: TAbUnZipper;
  Msg, FileName, ExtractDir: String;
  Position: Integer;
begin
  Position := Pos('" "', data);
  if Position <> 0 then begin
    FileName := Copy(data, 2, Position - 2);
    ExtractDir := Copy(data, Position + 3, Length(data) - (Position + 3));
    UnZip := TAbUnZipper.Create(nil);
    UnZip.FileName := FileName;
    UnZip.BaseDirectory := ExtractDir;
    UnZip.ExtractFiles('*.*');
    Msg := 'OK';
    UnZip.Destroy;
  end
  else begin
    Msg := 'Error';
  end;
  StrCopy(data, PChar(Msg));
  Result := 3;
end;

function _about(mWnd, aWnd: HWND; data, params: PChar; show, nopause: boolean):integer; stdcall;
begin
  StrCopy(data, 'zip.dll v1.02 by mc68000');
  Result := 3;
end;

exports
  _zip,
  _unzip,
  _about;

{$R *.RES}

begin
end.

