dialog dlm {
  title "mIRC Download Manager [/down]"
  size -200 -200 53 0
  option dbu
  list 1, 5 5 200 150, size
  box "", 17, 2 -1 206 252
  text "Filename:", 4, 5 159 32 8, right
  edit "", 5, 40 158 165 10, read autohs
  text "Received:", 6, 5 169 32 8, right
  edit "", 7, 40 168 50 10, read autohs
  text "from:", 8, 90 169 32 8, right
  edit "", 9, 125 168 80 10, read autohs
  text "Path to file:", 15, 5 179 32 8, right
  edit "", 14, 40 178 165 10, read autohs
  text "File info:", 20, 5 189 32 8, right
  edit "", 2, 40 188 165 10, read
  button "&Open", 3, 5 200 37 12
  button "&Delete File", 13, 45 200 37 12
  button "&Move File", 11, 85 200 37 12
  button "Ren&ame", 12, 125 200 37 12
  button "&Clear List", 10, 165 200 37 12
  check "Open Download Manager when Download is complete", 18, 30 215 145 8
  button "&Ok", 19, 65 235 37 12, ok
  button "Ca&ncel", 16, 105 235 37 12, cancel
  check "Replace _ with a space when Download is complete", 21, 30 223 145 10
}
alias -l init {
  set %_dlm.w 14
  .timerdlm.w -m 0 1 dlm.w %_dlm.w
}
alias -l dlm.w {
  if ((!$dialog(dlm)) || (%_dlm.w >= 425)) { .timerdlm.w off | %_dlm.h = $1 | .timerdlm.h -m 0 1 dlm.h $1 | return }
  x.y | dialog -s dlm %_dlm.x %_dlm.y %_dlm.w 0
  inc %_dlm.w $1
}
alias -l dlm.h {
  if ((!$dialog(dlm)) || (%_dlm.h >= 515)) { .timerdlm.h off | unset %_dlm.? | return }
  x.y | dialog -s dlm %_dlm.x %_dlm.y $calc(%_dlm.w - $1) %_dlm.h
  inc %_dlm.h $1
}
alias -l x.y {
  %_dlm.x = $int($calc(($window(-1).w / 2) - ($dialog(dlm).w /2)))
  %_dlm.y = $int($calc(($window(-1).h / 2) - ($dialog(dlm).h /2)))
}
on *:filercvd:*:{ down -a $nick $address $ctime $filename }
on *:dialog:dlm:init:0:{
  down -c 
  if ($hget(dlm,aopen)) { did -c dlm 18 }
  if ($hget(dlm,rename)) { did -c dlm 21 }
}
on *:dialog:dlm:sclick:19:{ down -s }
on *:dialog:dlm:sclick:1:{ -show }
on *:dialog:dlm:sclick:3:{ open }
on *:dialog:dlm:dclick:1:{ open }
on *:dialog:dlm:sclick:13:{ delete | -show }
on *:dialog:dlm:sclick:11:{ move }
on *:dialog:dlm:sclick:12:{ rename }
on *:dialog:dlm:sclick:10:{ if ($did(dlm,1,1)) { $-yesno(Are you sure to remove all files from the List? $+ $str($crlf,3) $+ Note: Files won't be removed from HDD.,clearlist) } }
alias down {
  foldercheck
  if (!$hget(dlm)) { hmake dlm | hload dlm tmp\settings }
  if ($1 == -a) {
    if ($hget(dlm,rename)) {
      if (!$exists($replace($5-,_,$chr(32)))) {
        !.rename $+(",$5-," ",$nofile($5-),$replace($nopath($5-),_,$chr(32)),")
        tokenize 32 $1-4 $replace($5-,_,$chr(32)) 
      }
    }
    if ($hget(dlm,aopen)) { dialog $+(-,$iif(!$dialog(dlm),m,v)) dlm dlm | init }
    if ($read(tmp\files,nw,$5-)) {
      var %x = $readn
      write -dl $+ %x tmp\files
      write -dl $+ %x tmp\info
    }
    write tmp\files $5- | write tmp\info $2-
    .timer 1 0 down -c
  }
  elseif ($1 == -c) {
    if ($dialog(dlm)) {
      did -r dlm 1
      loadbuf -o dlm 1 tmp\files
      did -z dlm 1
    }
  }
  elseif ($1 == -s) {
    hadd -m dlm aopen $did(dlm,18).state
    hadd -m dlm rename $did(dlm,21).state
    hsave dlm tmp\settings
  }
  else { dialog $+(-,$iif(!$dialog(dlm),m,v)) dlm dlm | init }
}
alias -l clearlist { foldercheck | did -r dlm 1,2,5,7,9,14 | write -c tmp\files | write -c tmp\info }
alias -l -yesno { if ($input($1,adiyg,mIRC Download Manager)) { $2 } }
alias -l -error { $left($input($1-,adiog,mIRC Download Manager),0) }
alias -l rename {
  if ($exists($did(dlm,1).seltext)) { 
    var %x = $did(dlm,1).seltext,%np = $nofile(%x) $+ $$input(The new Filename for $nopath(%x) $+ :,doe,mIRC Download Manager,$nopath(%x))
    if (%np !== %x) {
      if ($exists(%np)) { $-yesno(The file: $+ $str($crlf,2) $+ %np $str($crlf,2) $+ does already exists. $+ $crlf $+ Do you want to overwrite it?,!.remove $+(",%np,")) }
      if (!$exists(%np)) {
        !.rename $+(",%x," ",%np,")
        foldercheck
        if ($read(tmp\files,nw,%x)) {
          var %y = $readn
          var %ol = $read(tmp\info,nw,& & & %x)
          write -dl $+ %y tmp\files
          write -dl $+ %y tmp\info
        }
        write tmp\files %np
        write tmp\info $gettok(%ol,1-3,32) %np
        down -c | -show
      }
    }
  }
  elseif $did(dlm,1).seltext { -error $+(The file:,$str($crlf,2),$did(dlm,1).seltext,$str($crlf,2),doesn't exists!) }
  elseif $did(dlm,1,1) { -error You should select a file at first. }
}
alias -l move {
  if ($exists($did(dlm,1).seltext)) { 
    var %x = $did(dlm,1).seltext,%np = $+($$sdir($nofile(%x),Select the Path where to save your " $+ $nopath(%x) $+ "),$nopath(%x))
    if (%np != %x) {
      if ($exists(%np)) { $-yesno(The file: $+ $str($crlf,2) $+ %np $str($crlf,2) $+ does already exists. $+ $crlf $+ Do you want to overwrite it?,!.remove $+(",%np,")) }
      if (!$exists(%np)) {
        !.rename $+(",%x," ",%np,")
        foldercheck
        if ($read(tmp\files,nw,%x)) {
          var %y = $readn
          var %ol = $read(tmp\info,nw,& & & %x)
          write -dl $+ %y tmp\files
          write -dl $+ %y tmp\info
        }
        write tmp\files %np
        write tmp\info $gettok(%ol,1-3,32) %np
        down -c | -show
      }
    }
  }
  elseif $did(dlm,1).seltext { -error $+(The file:,$str($crlf,2),$did(dlm,1).seltext,$str($crlf,2),doesn't exists!) }
  elseif $did(dlm,1,1) { -error You should select a file at first. }
}
alias -l open {
  if ($exists($did(dlm,1).seltext)) { 
    run $did(dlm,1).seltext
    goto s
    :error
    if ($version > 6.13) {
      reseterror
      $-yesno(Can't open this File $+ $chr(44) this file is not a registered filetype of Windows $+ $chr(44) do you want to load the file into notepad?,run notepad $did(dlm,1).seltext)
    }
    :s
  } 
  elseif $did(dlm,1).seltext { -error $+(The file:,$str($crlf,2),$did(dlm,1).seltext,$str($crlf,2),doesn't exists!) }
  elseif $did(dlm,1,1) { -error You should select a file at first. }
}
alias -l delete {
  var %x = $did(dlm,1).sel
  if ($exists($did(dlm,1).seltext)) { $-yesno(Are you sure to remove the file: $+ $crlf $+ $did(dlm,1).seltext,!.remove " $+ $did(dlm,1).seltext $+ ") | -show } 
  if ($did(dlm,1).sel) && (!$exists($did(dlm,1).seltext)) {
    write -dl $+ $did(dlm,1).sel tmp\files
    write -dl $+ $did(dlm,1).sel tmp\info
    down -c
    if ($did(dlm,1,%x)) { did -c dlm 1 %x }
    elseif ($calc($did(dlm,1,%x) - 1)) { did -c dlm 1 $calc(%x - 1) }
  }
}
alias -l -show {
  foldercheck
  did -r dlm 2,5,7,9,14
  if ($did(dlm,1).seltext) {
    var %x = $ifmatch
    tokenize 32 $read(tmp\info,nw,& & & %x)
    did -a dlm 5 $nopath(%x)
    did -a dlm 7 $asctime($3,dd.mm.yy - HH:nn)
    did -a dlm 9 $1 ( $+ $2 $+ )
    did -a dlm 14 $nofile($4-)
    if ($exists($4-)) {
      did -a dlm 2 Size: $bytes($file($4-).size).suf - Modified: $asctime($file($4-).mtime,dd.mm.yy - HH:nn)
    }
    else { did -a dlm 2 File has been removed, has been moved or renamed. }
  }
}
alias -l foldercheck {
  if (!$isdir(tmp)) { mkdir tmp }
  if (!$exists(tmp\settings)) { write -c tmp\settings }
  if (!$exists(tmp\files)) { write -c tmp\files }
  if (!$exists(tmp\info)) { write -c tmp\files }
}