;Script Name: Multi-Network Connection Manager
;Created: 5/04/2003
;Published: 19/08/2003
;Author: WarrenG
;Copyright: No
;
;Information:
;This script is an advanced version of the normal mirc options server connectivty.
;Using this script you can add/delete/sort servers from the list connect/new status window connect just like the normal mirc options tab however, 
;with the added option to select a server from the list, add it to an auto connect list so that you can connect to multiple networks when you start your mirc.
;The reason why I scripted this is for the simple fact that mirc didn't have the ability to connect to multiple networks when I started mirc automatically.
;
;Usage:
;Load the script into remote: /load -rs servercon.mrc
;Open the dialog, Right+click in any window, MNCM (Multi-Network Connection Manager)
;Select a server from the above drop down boxes, pressing '<' will add the server, '>' will remove a select server from the auto connects list box. '§' will refresh the list.
;
;Reconnect All - Reconnects all the servers in the auto connects list
;Disconnect All - Disconnects all the servers in the auto connects list.
;
;This script disables mircs auto connect on startup.

dialog nservers {
  title "Multi-Network Connection Manager"
  size -1 -1 378 225
  option pixels
  list 1, 3 3 112 194, sort size extsel hsbar vsbar
  combo 2, 225 3 98 73, drop
  text "IRC Network:", 3, 148 6 74 16, right
  combo 4, 130 28 194 80, drop
  edit "", 5, 202 73 172 21
  edit "", 6, 202 97 172 21
  edit "", 7, 202 121 172 21
  edit "", 8, 202 145 172 21
  edit "", 9, 202 169 100 21, pass
  button "Add", 10, 330 4 44 19
  button "Save", 11, 330 28 44 19
  button "Delete", 12, 330 52 44 19
  button "Connect", 13, 214 198 75 21
  text "* Description:", 14, 125 75 74 16, right
  text "* IRC Server:", 15, 125 100 74 16, right
  text "* Port(s):", 16, 125 124 74 16, right
  text "* Group:", 17, 125 147 74 16, right
  text "Password:", 18, 125 171 74 16, right
  button "Reconnect All", 19, 0 198 75 21
  button "Disconnect All", 20, 78 198 75 21
  button "Close", 21, 315 171 50 23, ok
  button "<", 22, 116 99 15 14
  button ">", 23, 116 113 15 14
  button "§", 24, 116 128 15 19
  check "New Status", 25, 291 199 77 20
  button "Sort", 26, 279 52 44 19
}

on *:dialog:nservers:init:*: { 
  nscfac $dname
  nscfcbs $dname
  did -b $dname 11
  nscfeb $dname 4
}
on *:dialog:nservers:edit:*: {
  if (($did == 5) || ($did == 6) || ($did == 7) || ($did == 8) || ($did == 9)) { 
    if ($server($did($dname,6)).desc == $did($dname,5)) && ($server($did($dname,6)).port == $did($dname,7)) && ($server($did($dname,6)).group == $did($dname,8)) && ($server($did($dname,6)).pass == $did($dname,9)) did -b $dname 11
    elseif ($did($dname,11).enabled == $false) did -e $dname 11
  }
}
on *:dialog:nservers:sclick:*: {
  if ($did == 1) { 
    did -r $dname 4
    if ($left($did(1).seltext,2) != .:) nscfeb $dname 1 nowhile
  }
  elseif ($did == 2) {
    did -r $dname 4
    if ($did($dname,2) == All) { 
      nscfac $dname
      nscfcbs $dname
      did -b $dname 11
      nscfeb $dname 4
    }
    elseif ($did($dname,2) == Randoms) {
      var %items = 1
      while (%items <= $server(0)) {
        if ($server(%items).group isnum) && ($gettok($server(%items).desc,1,32) == Random) did -a $dname 4 $server(%items).desc
        inc %items
      }
      did -c $dname 4 1
      nscfeb $dname 1 nowhile
    }
    else {
      var %items = 1
      while (%items <= $server(0)) {
        if ($server(%items).group == $did($dname,2)) did -a $dname 4 $server(%items).desc
        inc %items
      }
      :2end
      did -c $dname 4 1
      nscfeb $dname 4
    }
  }
  elseif ($did == 4) nscfeb $dname 4
  elseif ($did == 10) {
    if ($did($dname,5) != $null) && ($did($dname,6) != $null) && ($did($dname,7) != $null) && ($did($dname,8) != $null) { 
      server -as $did($dname,6) -p $did($dname,7) -g $did($dname,8) $iif($did($dname,9) != $null,-w $did($dname,9)) -d $did($dname,5)
      did -r $dname 2,4
      nscfac $dname
      nscfcbs $dname
      did -b $dname 11
      nscfeb $dname 4
    }
    else echo -a One or more fields contain $!null data. Please fill all (*) mandatory fields.
  }
  elseif ($did == 11) { 
    if ($did($dname,5) != $null) && ($did($dname,6) != $null) && ($did($dname,7) != $null) && ($did($dname,8) != $null) {
      server -as $did($dname,6) -p $did($dname,7) -g $did($dname,8) $iif($did($dname,9) != $null,-w $did($dname,9)) -d $did($dname,5) 
      nscfac $dname
      nscfcbs $dname
      did -b $dname 11
      nscfeb $dname 4
    }
    else echo -a One or more fields contain $!null data. Please fill all (*) mandatory fields.
  }
  elseif ($did == 12) { 
    server -r $did($dname,4)
    did -d $dname 4 $didwm($dname,4,$did($dname,4)) 
    nscfac $dname
    nscfcbs $dname
    did -b $dname 11
    nscfeb $dname 4
  }
  elseif ($did == 13) scon $activecid server $iif($did($dname,25).state == 1,-m) $did($dname,6) $+ : $did($dname,7) $did($dname,9)
  elseif ($did == 19) {
    var %num = 1
    while (%num <= $ini($nscfile,networks,0)) {
      var %value = $ini($nscfile,networks,%num)
      /scid $nsclcn($ini($nscfile,networks,%num)).cid

      if ($nsclcn(%value).status == disconnected) server $nscserver(%num)
      elseif ($nsclcn(%value).status == $null) server -m $nscserver(%num)

      inc %num
    }
  }
  elseif ($did == 20) {
    var %num = 1
    while (%num <= $ini($nscfile,networks,0)) {
      var %value = $ini($nscfile,networks,%num)
      /scid $nsclcn($ini($nscfile,networks,%num)).cid

      if (connect* iswm $nsclcn(%value).status) disconnect

      inc %num
    }
  }
  elseif ($did == 22) {
    var %item = $iif($did(nservers,8) isnum,$remove($did(nservers,4),random,server,$chr(32)),$did($dname,8))
    writeini $nscfile networks %item $did($dname,5) $+ SERVER: $+ $did($dname,6) $+ : $+ $did($dname,7) $+ $iif($did($dname,9) != $null,: $+ $did($dname,9)) $+ GROUP: $+ $did($dname,8)
    nscfac $dname
  }
  elseif ($did == 23) { 
    remini $nscfile networks $gettok($did($dname,1).seltext,1,58) $gettok($did($dname,1).seltext,2-,58)
    nscfac $dname
  }
  elseif ($did == 24) nscfac $dname
  elseif ($did == 26) {
    server -s
    nscfcbs $dname
  }
}
on 1:start: if (%nsc == on) nscctn
on *:load: { 
  set %ncs on
  writeini mirc.ini options n0 0, $+ $gettok($readini(mirc.ini,options,n0),2-,44)
  dialog -iemdo nservers nservers
  echo -a HELLO! =) Thanks for choosing Network Servers Control for your multi-server connecting needs
  .timer 1 5 echo -a Please note that your auto connecting feature in mirc has been disabled!
  .timer 1 10 echo -a Don't Panic!, You don't need it now that you have Network Servers Control loaded.
  .timer 1 15 echo -a Please begin by adding networks to the auto connects list box by using the drop boxes and '<' button.
  .timer 1 20 echo -a Once you have done this, please press the Reconnect All or close and open mirc.
}
on *:unload: { 
  unset %ncs
  remove $nscfile
}
menu @null { 
  .MNCM
  ..$iif($dialog(nservers),Show,Open) Dialog: dialog $iif($dialog(nservers),-vie,-iemdo nservers) nservers
  ..Turn $iif(%nsc == on,Off,On): $iif(%nsc == on,unset %nsc,set %nsc on)
  ..Reconnect All: {
    var %num = 1
    while (%num <= $ini($nscfile,networks,0)) {
      var %value = $ini($nscfile,networks,%num)
      /scid $nsclcn($ini($nscfile,networks,%num)).cid

      if ($nsclcn(%value).status == disconnected) server $nscserver(%num)
      elseif ($nsclcn(%value).status == $null) server -m $nscserver(%num)

      inc %num
    }
  }
  ..Disconnect All: {
    var %num = 1
    while (%num <= $ini($nscfile,networks,0)) {
      var %value = $ini($nscfile,networks,%num)
      /scid $nsclcn($ini($nscfile,networks,%num)).cid

      if (connect* iswm $nsclcn(%value).status) disconnect

      inc %num
    }
  }
}

;ALIASES
;nscfile - nsc File
;nscctn - nsc Connections
;nscfac - nsc Fill Auto Connects
;nscserver - nsc Server Properties
;nscfeb - nsc Fill Edit Boxes
;nscfcbs - nsc Fill Connection Boxes
;nsclcn - nsc Channel Connection Properties
;nsccoi - check if match in $did 1

alias nscfile return nscnetworks.ini
alias nsccoi { var %value = $didwm($1,1,* $+ $did($1,5) $+ *,2)) | if (%value != 0) did -c $1 1 %value | else did -u $1 1 }
alias nscctn {
  var %num = 1
  while (%num <= $nscserver(0)) {
    server $iif(%num > 1,-m) $nscserver(%num) $+ : $nscserver(%num).port $nscserver(%num).pass
    inc %num
  }
}
alias nscfac {
  did -r $1 1
  var %num = 1
  while (%num <= $ini($nscfile,networks,0)) {
    var %value = $readini($nscfile,networks,$ini($nscfile,networks,%num))
    did -az $1 1 $ini($nscfile,networks,%num) $+ : %value
    inc %num
  }
  did -a $1 1 .:Auto Connects
}
alias nscserver {
  if ($1 isnum) var %value = $readini($nscfile,networks,$ini($nscfile,networks,$1))
  elseif ($1 != $null) var %value = $readini($nscfile,networks,$1)

  if ($prop == $null) { 
    if ($1 == 0) return $ini($nscfile,networks,0)
    else return $gettok($mid(%value,$pos(%value,SERVER,1-)),2,58)
  }
  elseif ($prop == desc) return $left(%value,$calc($poscs(%value,SERVER,1) -1))
  elseif ($prop == group) return $gettok($mid(%value,$poscs(%value,GROUP,1)),2,58)
  elseif ($prop == port) return $removecs($gettok($mid(%value,$poscs(%value,SERVER,1)),3,58),GROUP)
  elseif ($prop == pass) { 
    var %pass = $removecs($gettok($mid(%value,$poscs(%value,SERVER,1)),4,58),GROUP)
    var %port = $gettok($mid(%value,$poscs(%value,GROUP,1)),2,58)
    if (%pass != %port) return $removecs($gettok($mid(%value,$poscs(%value,SERVER,1)),4,58),GROUP)
    else return $null
  }
}
alias nscfeb {
  ;$1 = $dname, $2 Dialog ID, $3 nowhile
  ;load nscfeb $dname 4
  ;from 1 nscfeb $dname 1

  if ($3 == nowhile) {
    var %value = $ini($nscfile,networks,$gettok($did($1,$2).seltext,1,58))
    goto nowhile
  }
  var %items = 1

  while (%items <= $server(0)) {

    :nowhile

    if ($3 == nowhile) var %getnum1 = $nscserver(%value).desc,%getnum2 = $nscserver(%value),%getnum3 = $nscserver(%value).port,%getnum4 = $nscserver(%value).group,%getnum5 = $nscserver(%value).pass
    else { 
      if ($server(%items).desc == $did($1,$2)) var %getnum1 = $server(%items).desc,%getnum2 = $server(%items),%getnum3 = $server(%items).port,%getnum4 = $server(%items).group, %getnum5 = $server(%items).pass
      else goto skip
    }
    else if ($3 != nowhile) goto skip

    did -o $1 5 1 %getnum1
    did -o $1 6 1 %getnum2
    did -o $1 7 1 %getnum3
    did -o $1 8 1 %getnum4
    did -o $1 9 1 %getnum5
    nsccoi $dname
    set %nscedited $did($1,6) -p $did($1,7) -g $did($1,8) -w $did($1,9) -d $did($1,5)
    if ($3 == nowhile) {
      did -c $1 2 $didwm($1,2,$iif($did($1,8) isnum,Randoms,$gettok($did($1,1).seltext,1,58)))

      var %items = 1
      while (%items <= $server(0)) {
        if ($did($1,2) == Randoms) if ($server(%items).group isnum) && ($gettok($server(%items).desc,1,32) == Random) did -a $1 4 $server(%items).desc
        else if ($server(%items).group == $did($1,2)) did -a $1 4 $server(%items).desc
        inc %items
      }

      did -c $1 4 $didwm($1,4,$nscserver($ini($nscfile,networks,$gettok($did($1,1).seltext,1,58))).desc)
    }
    halt

    :skip
    inc %items
  }
}
alias nscfcbs {
  did -r $1 2,4
  var %items = 1
  while (%items <= $server(0)) {
    if (%items == 1) didtok $1 2 32 All Randoms
    if ($server(%items).group !isnum) && ($didwm($1,2,$server(%items).group) == 0) did -a $1 2 $server(%items).group
    didtok $1 4 9 $server(%items).desc
    inc %items
  }
  did -c $1 2,4 1
}

;                       'Network Server Connection Location'
;This alias was created so i can list how many servers my bot was on, what networks/servers it was connected to, as well as how many channels and what channels it was in on a multi-server enviroment.
;Its was actually first created so I could demonstrate to one of mates online how easy it was to create. 
;Thanks to 'Shock's complaining I actually ended up needing this alias :)
;Please read all the below comments, I took the time to write it, so you can take the time reading it!

;The process is fairly simple, it connectes to each connection thats active and follows the proceudres its given.

;(For the n00bs) Props - Stand for properties, thats the '.prop' after you call the alias

;PROPS: .servers, .networks, .chans, .status
;$nsclcn(0) - returns the total numbers of channels by default
;$nsclcn(0).prop lists the varies servers, networks, channels and status's in a tokenized 44 manner.

;$nsclcn(#)  - Will return the group name of the group #, like 01 = Dalnet, 03 = EFnet etc

;PROPS: .server, .chans, .status, .cid, .nicktf, .nickchan
;$nsclcn($network) returns the total number of channels its connected to
;$nsclcn($network).prop returns the server connection, channels its in, connection status, cid value
;$nsclcn($network,$nick).nicktf returns $true/$false if $nick is on any channel in $network
;$nsclcn($network,$nick,$chan).nicktf returns $true/$false if $nick is on $chan in $network
;$nsclcn($network,$nick).nickchan returns tokenized 44 channels that you and $nick is on.

;PROPS: .servers, .networks, .status
;$nsclcn($chan) returns the total connections that you are in $chan
;$nsclcn($chan).prop returns the servers, networks and status of each channel matching $chan

alias nsclcn {
  var %num = 1
  while (%num <= $scon(0)) {
    if ($1 == 0) { 
      if ($prop == $null) { /scid $scon(%num) | var %value = $calc(%value + $chan(0)) }
      elseif ($prop == servers) var %value = $addtok(%value,$scon(%num).server,44)
      elseif ($prop == networks) var %value = $addtok(%value,$scon(%num).network,44)
      elseif ($prop == chans) { /scid $scon(%num) | var %num2 = 1 | while (%num2 <= $chan(0)) { var %value = $addtok(%value,$chan(%num2),44) | inc %num2 } }
      elseif ($prop == status) { /scid $scon(%num) | var %value = $addtok(%value,$scon(%num).status,44) }
    }
    elseif ($1 isnum) {
      var %num1 = 1
      while (%num1 <= $server(0)) {
        if ($server(%num1).group == $1) return $removecs($server(%num1).desc,Random,server)
        inc %num1
      }
    }
    else {
      var %num1 = 1
      while (%num1 <= $scon(0)) {
        if ($scon(%num1).network isnum) { 
          var %gisnum = $removecs($server($scon(%num1).network).desc,Random,server,$chr(32))
          if (%gisnum == $1) goto ifone
        }
        inc %num1
      }
      if ((%gisnum == $1) || ($remove($nsclcn($scon(%num).network),$chr(32)) == $1) || ($scon(%num).network == $1)) {
        :ifone
        if ($prop == $null) { /scid $scon(%num) | var %value = $chan(0) }
        elseif ($prop == server) var %value = $scon(%num).server
        elseif ($prop == chans) { /scid $scon(%num) | var %num2 = 1 | while (%num2 <= $chan(0)) { var %value = $addtok(%value,$chan(%num2),44) | inc %num2 } }
        elseif ($prop == status) var %value = $scon(%num).status
        elseif ($prop == cid) var %value = $scon(%num)
        elseif (nick* iswm $prop) {
          if ($2 != $null) {
            /scid $scon(%num) | var %num2 = 1 | while (%num2 <= $chan(0)) { var %chans = $addtok(%chans,$chan(%num2),44) | inc %num2 }
            var %num2 = 1
            while (%num2 <= $numtok(%chans,44)) { 
              if ($2 ison $gettok(%chans,%num2,44)) { 
                if ($prop == nicktf) && ($3 == $null) return $true
                elseif ($prop == nicktf) && ($3 == $gettok(%chans,%num2,44)) return $true
                elseif ($prop == nickchan) var %value = $addtok(%value,$gettok(%chans,%num2,44),44)
              }
              elseif (%num2 == $numtok(%chans,44)) return $iif($prop == nicktf,$false,$iif($prop == nickchan,$null))
              inc %num2
            }
          }
          else { echo -a 7Error - Usage: $alias $+ $!nsclcn($network,$nick).nickf | halt }
        }
      }
      else {
        var %num2 = 1
        while (%num2 <= $chan(0)) { 
          /scid $scon(%num)
          if ($chan(%num2) == $1) {
            if ($prop == $null) var %value = $calc(%value + 1)
            elseif ($prop == servers) var %value = $addtok(%value,$scon(%num).server,44)
            elseif ($prop == networks) var %value = $addtok(%value,$scon(%num).network,44)
            elseif ($prop == status) var %value = $chan(%num2).status
          }
          inc %num2 
        }
      }
    }
    inc %num
  }
  return %value
}
