/***************************************************/
/*  VStyle.dll v3.0 by da^hype (Shahir Reza Ali)   */
/* da-hype@codedb.org					           */
/* www.codedb.org								   */
/* Malaysian Made.                                 */
/***************************************************/

//NOTE:  The VStyle.dll will only work with Windows XP or higher!!!
#pragma check_stack(off)
#pragma comment(linker,"/OPT:NOWIN98")
#pragma comment(lib,"uxtheme.lib")
#include <windows.h>
#include <uxtheme.h>
#include <Winuser.h>

// general constants
#define mFunc(x) int __stdcall x(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
#define mReturn(x) {lstrcpy(data,x);return 3;}

BOOL CALLBACK RemoveAllVS(HWND hWnd,LPARAM lp)
{
	if (lp)
	//add control's style
	SetWindowTheme(hWnd,NULL,NULL);
	else
	//remove control's style
	SetWindowTheme(hWnd,L" ",L" ");
	return TRUE;
}

BOOL CALLBACK AddAllVS(HWND hWnd,LPARAM lp)
{
	if (lp)
	//add control's style
	SetWindowTheme(hWnd,NULL,NULL);
	else
	//remove control's style
	SetWindowTheme(hWnd,L" ",L" ");
	return TRUE;
}

/*
 * Get the windows theme from @window or dialog. (Windows XP only)
 * $dll(VStyle.dll,GetTheme,.)
 *
 */
mFunc(GetTheme)
{
	WCHAR myTheme[900];
	GetCurrentThemeName(myTheme,900,NULL,900,NULL,900);
	WideCharToMultiByte(CP_ACP,MB_PRECOMPOSED,myTheme,900,data,sizeof(myTheme) / sizeof(myTheme[0]),NULL,NULL);
	wsprintf(data,"%lS",myTheme);
	return 3;
}
/*
 * Remove the windows theme from @window or dialog. (Windows XP only)
 * $dll(VStyle.dll,NoTheme,$window($active).hwnd|$dialog($dname).hwnd)
 *
 */
mFunc(NoTheme)
{
	HWND mircwindow = (HWND)atol(data);
	//make sure the window handle was valid
	if (!IsWindow(mircwindow))
		mReturn("$false");
	//remove visual style
	SetWindowTheme(mircwindow,L" ",L" ");
	EnumChildWindows(mircwindow,RemoveAllVS,0);
	strcpy(data,"S_OK");
	return 3;
}

/*
 * Adds the windows theme to @window or dialog . (Windows XP only)
 * $dll(VStyle.dll,Theme,$window($active).hwnd|$dialog($dname).hwnd)
 *
 */
mFunc(Theme)
{
	HWND mircwindow = (HWND)atol(data);
	//make sure the window handle was valid
	if (!IsWindow(mircwindow))
		mReturn("$false");
	//re-add visual style
	SetWindowTheme(mircwindow,NULL,NULL);
	EnumChildWindows(mircwindow,AddAllVS,1);
	strcpy(data,"S_OK");
	return 3;
}
/*
 * Enables mIRC's themes
 * /dll VStyle.dll MircTheme .
 *
 */
mFunc(MircTheme)
{
	SetWindowTheme(mWnd,NULL,NULL);
	strcpy(data,"S_OK");
	return 3;
}

/*
 * Disables mIRC's themes
 * /dll VStyle.dll MircNoTheme .
 *
 */
mFunc(MircNoTheme)
{
	SetWindowTheme(mWnd,L" ",L" ");
	strcpy(data,"S_OK");
	return 3;
}

/*
 * Dll Info dialog
 * $dll(VStyle.dll,DllInfo,.)
 *
 */
int WINAPI DllInfo(HWND,HWND,char *data,char*,BOOL,BOOL)
{
	MessageBox(NULL, "Made by da^hype (Shahir Reza Ali). www.codedb.org", "VStyle.dll 3.0. Malaysian Made", MB_OK);
	return 0;
}
