/* SoulCursor Dll ********************************************************
 *
 * Version:			1.6.0.0.0
 * FileName:		soulcursor.dll
 * Date Created:	12/28/2004
 *
 * Author:			Soul_Eater
 * Comments:
 *		An MTS plugin allowing cursor changes.
 *      Doesnt have to be used with MTS though
 *
 *******************************************************************/
#pragma check_stack(off)
#pragma comment(linker,"/OPT:NOWIN98")
#pragma comment(lib, "comctl32.lib")
#pragma comment(lib, "Oleacc.lib")
#include <windows.h>
#include <winuser.h>
#include <stdio.h>
#include <commctrl.h>
#include <windef.h>
HWND mwnd, window;

char *StripSpace(char *text)
{
	char *Text = text;
	int slot = 0,num = strlen(text);
	if (text[0] == ' ')
	{
		for (int i = 1;i <= num;i++)
		{
			Text[slot] = text[i];
			slot++;
		}
	}
	return Text;
}
void Gettok(char *string,char *outstring,char sepchar,int whichTok,int maxlen) {
	int count = 0;
	int outputcount = 0;
	int tokencount = 0;
	while (string[count]) {
		if ((string[count] == sepchar) && (count != 0)) {
			if (tokencount == whichTok)
				break;
			tokencount++;
		}
		else if (tokencount == whichTok) { 
			if (outputcount == maxlen)
				break;
			outstring[outputcount] = string[count];
			outputcount++;
		}
		count++;
	}
	outstring[outputcount] = '\0';
	if (outstring[0] == 32)
		wsprintf(outstring,"%s",StripSpace(outstring));
	if (outstring[strlen(outstring)-1] == 32)
		outstring[strlen(outstring)-1] = '\0';
}

int __stdcall SwitchCursor(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, 
					   BOOL nopause)
{
  
    HWND window = FindWindowEx(mWnd,NULL,"mIRC_Switchbar",NULL);
    HCURSOR hcursor = (HCURSOR)LoadCursorFromFile((LPCTSTR)data);

	   if (hcursor == NULL) { 
		lstrcpy(data, "SC_ERR Invalid cursor file location");
		return 3;
	}

	SetClassLong(window,GCL_HCURSOR,(LONG)hcursor); 
   

   if (!IsWindow(window)) { 
	   lstrcpy(data,"SC_ERR Switchbar does not exist."); 
	   return 3; 
   }

  lstrcpy(data,"SC_OK Switchbar Cursor changed");
 return 3;

}
int __stdcall ToolCursor(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, 
					   BOOL nopause)
{
  
    HWND window = FindWindowEx(mWnd,NULL,"mIRC_Toolbar",NULL);
    HCURSOR hcursor = (HCURSOR)LoadCursorFromFile((LPCTSTR)data);

    if (hcursor == NULL) { 
		lstrcpy(data, "SC_ERR Invalid cursor file location");
		return 3;
	}

	SetClassLong(window,GCL_HCURSOR,(LONG)hcursor); 
   

   if (!IsWindow(window)) { 
	   lstrcpy(data,"SC_ERR Toolbar does not exist."); 
	   return 3; 
   }

  lstrcpy(data,"SC_OK Toolbar Cursor changed");
 return 3;

}

int __stdcall ScrollCursor(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, 
					   BOOL nopause)
{
  
	HWND window = FindWindowEx(mWnd,NULL,"MDIClient",NULL);
    HWND window1 = FindWindowEx(window,NULL,"mIRC_Status",NULL);
	HWND window2 = FindWindowEx(window1,NULL,"Static",NULL);
	HWND window3 = FindWindowEx(window2,NULL,"ScrollBar",NULL);
    HCURSOR hcursor = (HCURSOR)LoadCursorFromFile((LPCTSTR)data);

       if (hcursor == NULL) { 
		lstrcpy(data, "SC_ERR Invalid cursor file location");
		return 3;
	}

	SetClassLong(window3,GCL_HCURSOR,(LONG)hcursor); 
   

   if (!IsWindow(window3)) { 
	   lstrcpy(data,"SC_ERR Window does not exist."); 
	   return 3; 
   }

  lstrcpy(data,"SC_OK Scrollbar Cursor changed");
 return 3;

}

int __stdcall OtherCursor(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, 
					   BOOL nopause)
{
	char wind[150], char curs[999];


	Gettok(data,wind,'>',0,150); 
	Gettok(data,curs,'>',1,999);
  
	HWND window = (HWND)atoi(wind);
	 
	if (!IsWindow(window)) { 
	   lstrcpy(data,"SC_ERR Window does not exist."); 
	   return 3; 
   }
   
    HCURSOR hcursor = (HCURSOR)LoadCursorFromFile((LPCTSTR)curs);

	   if (hcursor == NULL) { 
		lstrcpy(data, "SC_ERR Invalid cursor file location");
		return 3;
	}

	SetClassLong(window,GCL_HCURSOR,(LONG)hcursor); 

  lstrcpy(data,"SC_OK Window Cursor changed");
 return 3;

}


int __stdcall NormalCursor(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, 
					   BOOL nopause)
{
    char wind[150], char curs[999];


	Gettok(data,wind,'>',0,150); 
	Gettok(data,curs,'>',1,999);
    
   if (stricmp(wind,"status") == 0) {
	
	HWND window = FindWindowEx(mWnd,NULL,"MDIClient",NULL);
    HWND window1 = FindWindowEx(window,NULL,"mIRC_Status",NULL);
	  if (!IsWindow(window1)) { 
	   lstrcpy(data,"SC_ERR Window does not exist."); 
	   return 3; 
   }
	HCURSOR hcursor = (HCURSOR)LoadCursorFromFile((LPCTSTR)curs);

	   if (hcursor == NULL) { 
		lstrcpy(data, "SC_ERR Invalid cursor file location");
		return 3;
	}

	SetClassLong(window1,GCL_HCURSOR,(LONG)hcursor);
   }

  if (stricmp(wind,"channel") == 0) {
	HWND window = FindWindowEx(mWnd,NULL,"MDIClient",NULL);
    HWND window1 = FindWindowEx(window,NULL,"mIRC_Channel",NULL);
	  if (!IsWindow(window1)) { 
	   lstrcpy(data,"MTS_ERR Window does not exist."); 
	   return 3; 
   }
	HCURSOR hcursor = (HCURSOR)LoadCursorFromFile((LPCTSTR)curs);

       if (hcursor == NULL) { 
		lstrcpy(data, "SC_ERR Invalid cursor file location");
		return 3;
	}

	SetClassLong(window1,GCL_HCURSOR,(LONG)hcursor);
  }
   if (stricmp(wind,"mdi") == 0) {
	  	HWND window1 = FindWindowEx(mWnd,NULL,"MDIClient",NULL);
   if (!IsWindow(window1)) { 
	   lstrcpy(data,"MTS_ERR Window does not exist."); 
	   return 3; 
   }
	HCURSOR hcursor = (HCURSOR)LoadCursorFromFile((LPCTSTR)curs);

   if (hcursor == NULL) { 
		lstrcpy(data, "SC_ERR Invalid cursor file location");
		return 3;
	}

	SetClassLong(window1,GCL_HCURSOR,(LONG)hcursor);

   } 
   
  lstrcpy(data,"SC_OK Normal Cursor changed");
 return 3;

}

int MsgBox(char *data)
  {
 int xa = MessageBox (mwnd, data ,"SoulCursor DLL" , MB_OK | MB_ICONINFORMATION );
 return 0;
}


int WINAPI DllInfo(HWND,HWND,char *data,char*,BOOL,BOOL)
{
   ShellExecute(NULL,"open","http://www.freewebz.com/souleata/",NULL,NULL,SW_SHOW);
   MsgBox("SoulCursor DLL v1.6 by Soul_Eater \n2005\nContact Information:\nAIM- SoulEata");
   return 0;
}
