; ✟ables $¢®iþ† by Valentino Decaroli caronte.ade@gmail.com ;

on *:start: {
  if (%treex == ON) .timer 1 0 dcxtreebar
}

;====================================================================================================================================================================================;
; treebarinfo | Talon http://forums.mirc.com/ubbthreads.php/topics/251981/Re:_Treebar_position                                                                                       ;
;====================================================================================================================================================================================;

alias treebarinfo {
  var %menu = $menubar , %tree = $treebar , %tool = $toolbar
  if (%menu) .menubar off
  if (%tool) .toolbar off
  if (!%tree) .treebar on

  var %tree.bw = $window(-2).w - $window(-2).dw , %tree.bh = $window(-2).h - $window(-2).dh
  var %tree.w = $window(-2).dw - $window(-3).w , %tree.h = $window(-2).dh - $window(-3).h
  var %tree.x = $window(-3).x - $window(-2).x , %tree.y = $window(-3).y - $window(-2).y

  var %orientation = $iif(!%tree.w,horizontal,$iif(!%tree.h,vertical))
  if (%orientation == horizontal) { /set %position $iif(%tree.y > %tree.bh,top,bottom) }
  else { /set %position $iif(%tree.x > %tree.bw,left,right) }

  if (%menu) .menubar on
  if (%tool) .toolbar on
  if (!%tree) .treebar off
  return %orientation %position
  ; //echo -a $treebarinfo
}

;====================================================================================================================================================================================;
; xtreebar_callback | Ook http://www.mircscripting.info/                                                                                                                             ;
;====================================================================================================================================================================================;

alias xtreebar_callback { 
  !if ($1 == geticons) { 
    ; geticons <type> <text> 
    !if ($2 == status) return 1 1 
    !if ($2 == channel) return 2 2 
    !if ($2 == custom) return 3 3 
    !if ($2 == send) return 4 4 
    !if ($2 == get) return 5 5 
    !if ($2 == notify) return 6 6 
    !if ($2 == query) return 7 7 
    !if (*folder iswm $2) return 8 8 
    !return 0 0 
  } 
  !if ($1 == gettooltip) { 
    !if ($2 == channel) { 
      !if ($3 == $chan($active)) return $chan($active) 
      !if ($chan($active)* iswm $3) return $chan($active) Channel 
    } 
    !if ($2 == status) return $3 
    !if ($2 == WindowFolder) return Custom Windows Folder 
  } 
} 

;===========================================================================================================================;
; alias dcxtreebar | VxD ~ caronte.ade@gmail.com ~ www.vxd.altervista.org ~ vxd.altervista.org ~ http://vxd.altervista.org                ;
;===========================================================================================================================;

alias dcxtreebar { 
  xtreebar -w clear 
  if ($isfile(%icostatus)) xtreebar -w 0 +a 1 %icostatus 
  if ($isfile(%icochan)) xtreebar -w 0 +a 2 %icochan
  if ($isfile(%icocust)) xtreebar -w 0 +a 3 %icocust 
  if ($isfile(%icosend)) xtreebar -w 0 +a 4 %icosend
  if ($isfile(%icoget)) xtreebar -w 0 +a 5 %icoget
  if ($isfile(%iconot)) xtreebar -w 0 +a 6 %iconot 
  if ($isfile(%icoq)) xtreebar -w 0 +a 7 %icoq  
  if ($isfile(%icodir)) xtreebar -w 0 +a 8 %icodir  
  xtreebar -c +b %treebarbg
  xtreebar -c +t %treetext 
  xtreebar -c +l %treeline 
  xtreebar -c +m %treemess 
  xtreebar -c +e %treevent
  xtreebar -c +M %messagebg
  xtreebar -c +S %treetextsb
  xtreebar -c +E %treetextevo
  xtreebar -c +z %treevent
  xtreebar -c +Z %treetextevo
  xtreebar -c +h %treeh
  xtreebar -c +H %treehot
  xtreebar -s tooltips infotip transparent 
  xtreebar -s balloon trackselect scroll rootlines showsel fadebuttons richtooltip
  xtreebar -f %textmode %xchartree %xdimtree %xcartree
  xtreebar -T 1 
} 


alias treebardialog {
  treebarinfo 
  /showmirc -x
  if (%position == left) {
    /set %pos_or -500
    /set %pos_vr -100
    /set %pos_lr 320
    /set %pos_lu 1080
  }
  if (%position == right) {
    /set %pos_or 1920
    /set %pos_vr -100
    /set %pos_lr 320
    /set %pos_lu 1080
  }
  if (%position == top) {
    /set %pos_or -100
    /set %pos_vr -100
    /set %pos_lr 1920
    /set %pos_lu 400
  }
  if (%position == bottom) {
    /set %pos_or -100
    /set %pos_vr 1600
    /set %pos_lr 1920
    /set %pos_lu 400
  }
  dialog -ma treebardialog treebardialog_table
  /xdialog -b treebardialog -hmnsvxzo
  /xdialog -R treebardialog +s $dcx(GetSystemColor, COLOR_WINDOW)
  if (%position == left) { cla_tree_lr } 
  if (%position == right) { cla_tree_lr } 
  if (%position == top) { cla_tree_tb } 
  if (%position == bottom) { cla_tree_tb } 
  .timer 1 0 xdialog -l treebardialog update
}

dialog treebardialog_table {
  title "treebardialog"
  size %pos_or %pos_vr %pos_lr %pos_lu
}

on *:dialog:treebardialog:*:*: {
  if ($devent == init) {
    /dcx Mark $dname treebardialog_cb  
    /xdialog -V $dname %pos_or %pos_vr %pos_lr %pos_lu
    /xdialog -t $dname transparentcolor none
    /xdialog -t $dname alpha none
    /xdialog -g $dname +b $dcx(GetSystemColor, COLOR_WINDOW)
    /xdialog -T $dname +bp 
    /xdialog -t $dname bgcolor $dcx(GetSystemColor, COLOR_WINDOW)
    if (%cur_x == ON) /xdialog -q $dname +f %cursore 
    !if (!$dcx(IsUsingDirectX)) {
      /echo -a DirectX Is Disabled.
      halt
    }
    ;// Call initilisation alias
    treebardialog_init_dcx
  }
}

alias -l treebardialog_init_dcx {
  /xdialog -E treebardialog +e -h
  if (%position == left) { /xdialog -a $dname +so 100 }
  if (%position == right) { /xdialog -a $dname +sn 100 }
  if (%position == top) { /xdialog -a $dname +sv 100 }
  if (%position == bottom) { /xdialog -a $dname +su 100 }
  .timer 1 0 /xdock -b $dialog(treebardialog).hwnd +s
  refresh_tree_controls
}


;// Callback alias for treebardialog
alias treebardialog_cb {
  if ($2 != mouse) { ; echo $color(info) -s */ treebardialog_cb: $1- }
  if ($2 == keyup) {
    if ($3 == 3) { /set %xchartree $xdid($1,3).text | .timer 1 0 ref_text | .timer 1 0 ref_char | refont_text | ref_char }
    elseif ($3 == 4) { /set %xcartree $xdid($1,4).text | .timer 1 0 ref_text | .timer 1 0 ref_char | refont_text | ref_char }
  }
  if ($2 == keydown) {
    if ($3 == 3) { if ($xdialog(treebardialog).key & 13) /set %xchartree $xdid($1,3).text | .timer 1 0 ref_text | .timer 1 0 ref_char | refont_text | ref_char }
    elseif ($3 == 4) { if ($xdialog(treebardialog).key & 13) /set %xcartree $xdid($1,4).text | .timer 1 0 ref_text | .timer 1 0 ref_char | refont_text | ref_char }
    elseif ($3 == 5) { if ($xdid(treebardialog, 5).caretpos == 1 2) /set %xdimtree $xdid($1,5).text | .timer 1 0 ref_text | .timer 1 0 ref_char | refont_text | ref_char }
  }
  if ($2 == sclick) {
    if ($3 == 1) { .run charmap.exe }
    elseif ($3 == 2) {  if ($dialog(char_set) != $null) xdialog -x char_set | if ($dialog(fonts_set) != $null) /xdialog -x fonts_set |  if ($dialog(size_set) != $null) /xdialog -x size_set | /xdialog -h treebardialog | /xdialog -x treebardialog | .timer -m 1 100 /xdock -R 0 | .timer -m 1 200 /xdock -R 1 | .timer 1 0 dcxtreebar }
    elseif ($3 == 3) { .timer 1 0 xdid -r treebardialog 3 }
    elseif ($3 == 4) { .timer 1 0 xdid -r treebardialog 4 }
    elseif ($3 == 5) { .timer 1 0 xdid -r treebardialog 5 }
    elseif ($3 == 6) { char_set }
    elseif ($3 == 7) { fonts_set }
    elseif ($3 == 8) { size_set }
    elseif ($3 == 9) { /set %textmode +a | xdid -c treebardialog 9 | xdid -u treebardialog 10 | xdid -u treebardialog 11 | ref_text | ref_char | refont_text | ref_char | resize_text }
    elseif ($3 == 10) { /set %textmode +i | xdid -c treebardialog 10 | xdid -u treebardialog 9 | xdid -u treebardialog 11 | ref_text | ref_char | refont_text | ref_char | resize_text } 
    elseif ($3 == 11) { if (%textmode == +i) /set %textmode +bi | if (%textmode == +a) /set %textmode +ba | xdid -c treebardialog 11 | xdid -u treebardialog 10 | xdid -u treebardialog 9 | ref_text | ref_char | refont_text | ref_char | resize_text }
    elseif ($3 == 12) { /set %treebarbg $dll(dlls\color.dll,Color,.) | background_color_tree | refresh_dialog_tree }
    elseif ($3 == 13) { /set %treetext $dll(dlls\color.dll,Color,.) | text_color_tree | refresh_dialog_tree }
    elseif ($3 == 14) { /set %treeline $dll(dlls\color.dll,Color,.) | line_color_tree | refresh_dialog_tree }
    elseif ($3 == 15) { /set %treetextsb $dll(dlls\color.dll,Color,.) | selected_color_tree | refresh_dialog_tree }
    elseif ($3 == 16) { /set %messagebg $dll(dlls\color.dll,Color,.) | messagebg_color_tree | refresh_dialog_tree }
    elseif ($3 == 17) { /set %treemess $dll(dlls\color.dll,Color,.) | messages_color_tree | refresh_dialog_tree }
    elseif ($3 == 18) { /set %treeh $dll(dlls\color.dll,Color,.) | hottext_color_tree | refresh_dialog_tree }
    elseif ($3 == 19) { /set %treevent $dll(dlls\color.dll,Color,.) | event_color_tree | refresh_dialog_tree }
    elseif ($3 == 20) { /set %treetextevo $dll(dlls\color.dll,Color,.) | eventBG_color_tree | refresh_dialog_tree }
    elseif ($3 == 21) { /set %treehot $dll(dlls\color.dll,Color,.) | hot_color_tree | refresh_dialog_tree }
    elseif ($3 == 22) { .set %icostatus $shortfn($sfile(themes\ico\*.ico,Choose image format .ico,Ok)) | icostatus_tree | refresh_dialog_tree }
    elseif ($3 == 23) { .set %icocust $shortfn($sfile(themes\ico\*.ico,Choose image format .ico,Ok)) | icocust_tree | refresh_dialog_tree }
    elseif ($3 == 24) { .set %iconot $shortfn($sfile(themes\ico\*.ico,Choose image format .ico,Ok)) | iconot_tree | refresh_dialog_tree }
    elseif ($3 == 25) { .set %icoq $shortfn($sfile(themes\ico\*.ico,Choose image format .ico,Ok)) | icoq_tree | refresh_dialog_tree }
    elseif ($3 == 26) { .set %icochan $shortfn($sfile(themes\ico\*.ico,Choose image format .ico,Ok)) | icochan_tree | refresh_dialog_tree }
    elseif ($3 == 27) { .set %icosend $shortfn($sfile(themes\ico\*.ico,Choose image format .ico,Ok)) | icosend_tree | refresh_dialog_tree }
    elseif ($3 == 28) { .set %icoget $shortfn($sfile(themes\ico\*.ico,Choose image format .ico,Ok)) | icoget_tree | refresh_dialog_tree }
    elseif ($3 == 29) { .set %icodir $shortfn($sfile(themes\ico\*.ico,Choose image format .ico,Ok)) | icodir_tree | refresh_dialog_tree }
    elseif ($3 == 30) { .coloretrex | refresh_dialog_tree | xdid -w treebardialog 30 +n 0 themes\icons\colors.ico | xdid -w treebardialog 31 +ng 0 themes\icons\folder.ico }
    elseif ($3 == 31) { .icontrex | icodir_tree | refresh_dialog_tree | xdid -w treebardialog 31 +n 0 themes\icons\folder.ico | xdid -w treebardialog 30 +ng 0 themes\icons\colors.ico }
  }
  if ($2 == mouseenter) {  }
  if ($2 == mouseleave) {  }
}

/cb_treebardialog treebardialog return 3
/cb_treebardialog treebardialog return 4
/cb_treebardialog treebardialog return 5
/cb_treebardialog treebardialog edit 3
/cb_treebardialog treebardialog edit 4
/cb_treebardialog treebardialog edit 5
/cb_treebardialog treebardialog keydown 3 13
/cb_treebardialog treebardialog keydown 4 13
/cb_treebardialog treebardialog keydown 5 13
/cb_treebardialog treebardialog copy 3 
/cb_treebardialog treebardialog copy 4 
/cb_treebardialog treebardialog copy 5 
/cb_treebardialog treebardialog cut 3 
/cb_treebardialog treebardialog cut 4 
/cb_treebardialog treebardialog cut 5 

alias refresh_dialog_tree { 
  if (%position == left) { cla_tree_lr } 
  if (%position == right) { cla_tree_lr } 
  if (%position == top) { cla_tree_tb } 
  if (%position == bottom) { cla_tree_tb } 
  .timer -m 1 1 xdialog -l treebardialog update 
  .timer -m 1 1 dcxtreebar 
}

alias refresh_tree_controls {
  tree_map
  tree_close
  xchar_tree
  charset_tree
  size_font_tree
  chars_prev
  fonts_prev
  size_prev
  mode_aliased_tree
  mode_norm_tree
  mode_bold_tree
  coloritr 
  iconetr
  refresh_dialog_tree
}
alias coloretrex {
  if ($xdialog(treebardialog, 22).isid == $true) /xdialog -d treebardialog  22
  if ($xdialog(treebardialog, 23).isid == $true) /xdialog -d treebardialog  23
  if ($xdialog(treebardialog, 24).isid == $true) /xdialog -d treebardialog  24
  if ($xdialog(treebardialog, 25).isid == $true) /xdialog -d treebardialog  25
  if ($xdialog(treebardialog, 26).isid == $true) /xdialog -d treebardialog  26
  if ($xdialog(treebardialog, 27).isid == $true) /xdialog -d treebardialog  27
  if ($xdialog(treebardialog, 28).isid == $true) /xdialog -d treebardialog  28
  if ($xdialog(treebardialog, 29).isid == $true) /xdialog -d treebardialog  29
  background_color_tree
  text_color_tree
  line_color_tree
  selected_color_tree
  messagebg_color_tree
  messages_color_tree
  hottext_color_tree
  event_color_tree
  eventBG_color_tree
  hot_color_tree
}
alias icontrex {
  if ($xdialog(treebardialog, 12).isid == $true) /xdialog -d treebardialog  12
  if ($xdialog(treebardialog, 13).isid == $true) /xdialog -d treebardialog  13
  if ($xdialog(treebardialog, 14).isid == $true) /xdialog -d treebardialog  14
  if ($xdialog(treebardialog, 15).isid == $true) /xdialog -d treebardialog  15
  if ($xdialog(treebardialog, 16).isid == $true) /xdialog -d treebardialog  16
  if ($xdialog(treebardialog, 17).isid == $true) /xdialog -d treebardialog  17
  if ($xdialog(treebardialog, 18).isid == $true) /xdialog -d treebardialog  18
  if ($xdialog(treebardialog, 19).isid == $true) /xdialog -d treebardialog  19
  if ($xdialog(treebardialog, 20).isid == $true) /xdialog -d treebardialog  20
  if ($xdialog(treebardialog, 21).isid == $true) /xdialog -d treebardialog  21
  icostatus_tree
  icocust_tree
  iconot_tree
  icoq_tree
  icochan_tree
  icosend_tree
  icoget_tree
  icodir_tree
}
alias ref_char {
  if ($dialog(char_set) != $null) {
    xdid -f char_set 1 %textmode ansi %xdimtree %xcartree
    xdid -f char_set 2 %textmode baltic %xdimtree %xcartree
    xdid -f char_set 3 %textmode chinesebig %xdimtree %xcartree
    xdid -f char_set 4 %textmode default %xdimtree %xcartree
    xdid -f char_set 5 %textmode easteurope %xdimtree %xcartree
    xdid -f char_set 6 %textmode gb2312 %xdimtree %xcartree
    xdid -f char_set 7 %textmode greek %xdimtree %xcartree
    xdid -f char_set 8 %textmode hangul %xdimtree %xcartree
    xdid -f char_set 9 %textmode mac %xdimtree %xcartree
    xdid -f char_set 10 %textmode oem %xdimtree %xcartree
    xdid -f char_set 11 %textmode russian %xdimtree %xcartree
    xdid -f char_set 12 %textmode shiftjis %xdimtree %xcartree
    xdid -f char_set 13 %textmode symbol %xdimtree %xcartree
    xdid -f char_set 14 %textmode turkish %xdimtree %xcartree
    xdid -f char_set 15 %textmode vietnamese %xdimtree %xcartree
    xdid -f char_set 16 %textmode italic %xdimtree %xcartree
    .timer -m 1 1 xdialog -l char_set update
  }
}

alias ref_text {
  if ($dialog(treebardialog) != $null) {
    if ($xdialog(treebardialog, 1).isid == $true) xdid -f treebardialog 1 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 2).isid == $true) xdid -f treebardialog 2 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 3).isid == $true) xdid -f treebardialog 3 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 4).isid == $true) xdid -f treebardialog 4 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 5).isid == $true) xdid -f treebardialog 5 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 6).isid == $true) xdid -f treebardialog 6 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 7).isid == $true) xdid -f treebardialog 7 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 8).isid == $true) xdid -f treebardialog 8 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 9).isid == $true) xdid -f treebardialog 9 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 10).isid == $true) xdid -f treebardialog 10 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 11).isid == $true) xdid -f treebardialog 11 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 12).isid == $true) xdid -f treebardialog 12 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 13).isid == $true) xdid -f treebardialog 13 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 14).isid == $true) xdid -f treebardialog 14 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 15).isid == $true) xdid -f treebardialog 15 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 16).isid == $true) xdid -f treebardialog 16 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 17).isid == $true) xdid -f treebardialog 17 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 18).isid == $true) xdid -f treebardialog 18 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 19).isid == $true) xdid -f treebardialog 19 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 20).isid == $true) xdid -f treebardialog 20 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 21).isid == $true) xdid -f treebardialog 21 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 22).isid == $true) xdid -f treebardialog 22 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 23).isid == $true) xdid -f treebardialog 23 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 24).isid == $true) xdid -f treebardialog 24 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 25).isid == $true) xdid -f treebardialog 25 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 26).isid == $true) xdid -f treebardialog 26 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 27).isid == $true) xdid -f treebardialog 27 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 28).isid == $true) xdid -f treebardialog 28 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 29).isid == $true) xdid -f treebardialog 29 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 30).isid == $true) xdid -f treebardialog 30 %textmode %xchartree %xdimtree %xcartree
    if ($xdialog(treebardialog, 31).isid == $true) xdid -f treebardialog 31 %textmode %xchartree %xdimtree %xcartree
    .timer -m 1 1 dcxtreebar
    .timer -m 1 1 xdialog -l treebardialog update
  }
}

alias tree_map {
  if ($xdialog(treebardialog, 1).isid == $true) { /xdid -h treebardialog 1 +c 5 | /xdialog -d treebardialog 1 }
  ;// Initialising control: mapchars (Button 1)
  if ($xdialog(treebardialog, 1).isid != $true) {
    if (%position == top) /xdialog -c treebardialog 1 button 80 2 200 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == bottom) /xdialog -c treebardialog 1 button 80 2 200 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == left) /xdialog -c treebardialog 1 button 80 2 200 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == right) /xdialog -c treebardialog 1 button 80 2 200 36 tabstop default group tooltips bitmap shadow notheme transparent right
    /xdid -s treebardialog 1 +c 10
    if (%lang == en) { xdid -t treebardialog 1 Map Chars | xdid -T treebardialog 1 Map Chars }
    if (%lang == it) { xdid -t treebardialog 1 Mappa Caratteri | xdid -T treebardialog 1 Mappa Caratteri }
    if (%lang == es) { xdid -t treebardialog 1 Mapa de Caracteres | xdid -T treebardialog 1 Mapa de Caracteres }
    if (%lang == fr) { xdid -t treebardialog 1 Table des caractères | xdid -T treebardialog 1 Table des caractères }
    xdid -f treebardialog 1 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 1 1
    xdid -l treebardialog 1 %icosize
    xdid -x treebardialog 1 -hmnsvxzo
    xdid -s treebardialog 1 +c 5
    xdid -w treebardialog 1 +ng 0 themes\icons\font.ico
    xdid -w treebardialog 1 +hd 0 themes\icons\font.ico
    if (%cur_x == ON) /xdid -J treebardialog 1 +f %butt
    /xdid -C treebardialog 1 +b $dcx(GetSystemColor, COLOR_WINDOW)
  }
}

alias tree_close {
  if ($xdialog(treebardialog, 2).isid == $true) { /xdid -h treebardialog 2 +c 5 | /xdialog -d treebardialog 2 }
  ;// Initialising control: close (Button 2)
  if ($xdialog(treebardialog, 2).isid != $true) {
    if (%position == top) /xdialog -c treebardialog 2 button 2 2 36 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == bottom) /xdialog -c treebardialog 2 button 2 2 36 36 tabstop default group tooltips bitmap shadow notheme transparent right  
    if (%position == left) /xdialog -c treebardialog 2 button 2 2 36 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == right) /xdialog -c treebardialog 2 button 2 2 36 36 tabstop default group tooltips bitmap shadow notheme transparent right 
    /xdid -s treebardialog 2 +c 10
    if (%lang == en) xdid -T treebardialog 2 Close
    if (%lang == it) xdid -T treebardialog 2 Chiudi
    if (%lang == es) xdid -T treebardialog 2 Cerrar
    if (%lang == fr) xdid -T treebardialog 2 Fermer
    xdid -f treebardialog 2 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 2 1
    xdid -l treebardialog 2 %icosize
    xdid -x treebardialog 2 -hmnsvxzo
    xdid -s treebardialog 2 +c 5
    xdid -w treebardialog 2 +ng 0 themes\icons\close.ico
    xdid -w treebardialog 2 +hd 0 themes\icons\close.ico
    if (%cur_x == ON) /xdid -J treebardialog 2 +f %butt
    /xdid -C treebardialog 2 +b $dcx(GetSystemColor, COLOR_WINDOW)
  }
}

alias xchar_tree {
  if ($xdialog(treebardialog, 3).isid == $true) /xdialog -d treebardialog  3
  if ($xdialog(treebardialog, 3).isid != $true) {
    if (%position == top) xdialog -c treebardialog 3 edit 2 40 250 40 autohs autovs showsel tabstop default group tooltips return 
    if (%position == bottom) xdialog -c treebardialog 3 edit 2 40 250 40 autohs autovs showsel tabstop default group tooltips return 
    if (%position == left) xdialog -c treebardialog 3 edit 2 40 250 40 autohs autovs showsel tabstop default group tooltips return 
    if (%position == right) xdialog -c treebardialog 3 edit 2 40 250 40 autohs autovs showsel tabstop default group tooltips return 
    xdid -f treebardialog 3 %textmode %xchartree %xdimtree %xcartree
    if (%lang == en) { xdid -T treebardialog 3 Can be any of the following: ansi, baltic, chinesebig, default, easteurope, gb2312, greek, hangul, mac, oem, russian, shiftjis, symbol, turkish, vietnamese. - Press ENTER to apply the changes  }  
    if (%lang == it) { xdid -T treebardialog 3 Può essere uno dei seguenti: ansi, baltic, chinesebig, default, easteurope, gb2312, greek, hangul, mac, oem, russian, shiftjis, symbol, turkish, vietnamese. - Premi ENTER per applicare le modifiche }
    if (%lang == es) { xdid -T treebardialog 3 Puede ser cualquiera de los siguientes: ansi, baltic, chinesebig, default, easteurope, gb2312, greek, hangul, mac, oem, russian, shiftjis, symbol, turkish, vietnamese. - Pulse ENTER para aplicar los cambios }
    if (%lang == fr) { xdid -T treebardialog 3 Peut être une des caractéristiques suivantes: ansi, baltic, chinesebig, default, easteurope, gb2312, greek, hangul, mac, oem, russian, shiftjis, symbol, turkish, vietnamese. - Sur ENTER pour appliquer les modifications }
    xdid -C treebardialog 3 +b $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C treebardialog 3 +k $dcx(GetSystemColor, COLOR_HIGHLIGHT)
    xdid -C treebardialog 3 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    xdid -C treebardialog 3 +g $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C treebardialog 3 +G $dcx(GetSystemColor, COLOR_WINDOW)
    /xdid -E treebardialog 3 CharSet $+   %xchartree
    if (%cur_x == ON) /xdid -J treebardialog 3 +f %cursore
    /xdid -y treebardialog 3 1
  }
}


alias charset_tree {
  if ($xdialog(treebardialog, 4).isid == $true) /xdialog -d treebardialog  4
  if ($xdialog(treebardialog, 4).isid != $true) {
    if (%position == top) xdialog -c treebardialog 4 edit 2 80 250 40 autohs autovs showsel tabstop default group tooltips return 
    if (%position == bottom) xdialog -c treebardialog 4 edit 2 80 250 40 autohs autovs showsel tabstop default group tooltips return 
    if (%position == left) xdialog -c treebardialog 4 edit 2 80 250 40 autohs autovs showsel tabstop default group tooltips return 
    if (%position == right) xdialog -c treebardialog 4 edit 2 80 250 40 autohs autovs showsel tabstop default group tooltips return 
    xdid -f treebardialog 4 %textmode %xchartree %xdimtree %xcartree
    if (%lang == en) { xdid -T treebardialog 4 Sets the type of character. Some examples Arial, Sans MS Comics, Thaoma, Verdana, Calibri - Press ENTER to apply the changes  } 
    if (%lang == it) { xdid -T treebardialog 4 Imposta il Tipo di Carattere. Qualche esempio Arial, Sans MS Comics, Thaoma, Verdana, Calibri - Premi ENTER per applicare le modifiche }
    if (%lang == es) { xdid -T treebardialog 4 Establece el tipo de carácter. Algunos ejemplos  Arial, Sans MS Comics, Thaoma, Verdana, Calibri - Pulse ENTER para aplicar los cambios }
    if (%lang == fr) { xdid -T treebardialog 4 Définit le type de caractère. Quelques exemples  Arial, Sans MS Comics, Thaoma, Verdana, Calibri - Sur ENTER pour appliquer les modifications }
    xdid -C treebardialog 4 +b $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C treebardialog 4 +k $dcx(GetSystemColor, COLOR_HIGHLIGHT)
    xdid -C treebardialog 4 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    xdid -C treebardialog 4 +g $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C treebardialog 4 +G $dcx(GetSystemColor, COLOR_WINDOW)
    /xdid -E treebardialog 4 FontName $+   %xcartree
    if (%cur_x == ON) /xdid -J treebardialog 4 +f %cursore
    /xdid -y treebardialog 4 1
  }
}

alias size_font_tree {
  if ($xdialog(treebardialog, 5).isid == $true) /xdialog -d treebardialog  5
  if ($xdialog(treebardialog, 5).isid != $true) {
    if (%position == left) xdialog -c treebardialog 5 edit 2 120 250 40 autohs autovs showsel tabstop default group tooltips number return  
    if (%position == right) xdialog -c treebardialog 5 edit 2 120 250 40 autohs autovs showsel tabstop default group tooltips number return  
    if (%position == top) xdialog -c treebardialog 5 edit 2 120 250 40 autohs autovs showsel tabstop default group tooltips number return  
    if (%position == bottom) xdialog -c treebardialog 5 edit 2 120 250 40 autohs autovs showsel tabstop default group tooltips number return 
    xdid -f treebardialog 5 %textmode %xchartree %xdimtree %xcartree
    if (%lang == en) { xdid -T treebardialog 5 Sets the size of Character. The minimum numeric value is 10 - Press ENTER to apply the changes  } 
    if (%lang == it) { xdid -T treebardialog 5 Imposta la dimensione del carattere. Il valore minimo numerico è 10 - Premi ENTER per applicare le modifiche }
    if (%lang == es) { xdid -T treebardialog 5 Establece el tamaño del personaje. El mínimo valor numérico es 10 - Pulse ENTER para aplicar los cambios }
    if (%lang == fr) { xdid -T treebardialog 5 Définit la taille des caractères. La valeur numérique minimale est 10 - Sur ENTER pour appliquer les modifications }
    xdid -C treebardialog 5 +b $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C treebardialog 5 +k $dcx(GetSystemColor, COLOR_HIGHLIGHT)
    xdid -C treebardialog 5 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    xdid -C treebardialog 5 +g $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C treebardialog 5 +G $dcx(GetSystemColor, COLOR_WINDOW)
    /xdid -E treebardialog 5 Size $+   %xdimtree
    if (%cur_x == ON) /xdid -J treebardialog 5 +f %cursore
    /xdid -y treebardialog 5 1
    /xdid -q treebardialog 5 2
  }
}

;=============================================preview=============================================================;

alias chars_prev {
  if ($xdialog(treebardialog, 6).isid == $true) { /xdid -h treebardialog 6 +c 5 | /xdialog -d treebardialog 6 }
  ;// Initialising control: mapchars (Button 6)
  if ($xdialog(treebardialog, 6).isid != $true) {
    if (%position == top) /xdialog -c treebardialog 6 button 252 40 36 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == bottom) /xdialog -c treebardialog 6 button 252 40 36 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == left) /xdialog -c treebardialog 6 button 252 40 36 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == right) /xdialog -c treebardialog 6 button 252 40 36 36 tabstop default group tooltips bitmap shadow notheme transparent right
    /xdid -s treebardialog 6 +c 10
    if (%lang == en) { xdid -t treebardialog 6 Map Chars | xdid -T treebardialog 6 CharSet }
    if (%lang == it) { xdid -t treebardialog 6 Mappa Caratteri | xdid -T treebardialog 6 CharSet }
    if (%lang == es) { xdid -t treebardialog 6 Mapa de Caracteres | xdid -T treebardialog 6 CharSet }
    if (%lang == fr) { xdid -t treebardialog 6 Table des caractères | xdid -T treebardialog 6 CharSet }
    xdid -f treebardialog 6 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 6 1
    xdid -l treebardialog 6 %icosize
    xdid -x treebardialog 6 -hmnsvxzo
    xdid -s treebardialog 6 +c 5
    xdid -w treebardialog 6 +ng 0 themes\icons\map.ico
    xdid -w treebardialog 6 +hd 0 themes\icons\map.ico
    if (%cur_x == ON) /xdid -J treebardialog 6 +f %butt
    /xdid -C treebardialog 6 +b $dcx(GetSystemColor, COLOR_WINDOW)
  }
}

alias fonts_prev {
  if ($xdialog(treebardialog, 7).isid == $true) { /xdid -h treebardialog 7 +c 5 | /xdialog -d treebardialog 7 }
  ;// Initialising control: mapchars (Button 7)
  if ($xdialog(treebardialog, 7).isid != $true) {
    if (%position == top) /xdialog -c treebardialog 7 button 252 80 36 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == bottom) /xdialog -c treebardialog 7 button 252 80 36 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == left) /xdialog -c treebardialog 7 button 252 80 36 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == right) /xdialog -c treebardialog 7 button 252 80 36 36 tabstop default group tooltips bitmap shadow notheme transparent right
    /xdid -s treebardialog 7 +c 10
    if (%lang == en) { xdid -T treebardialog 7 Sets the type of character. Some examples Arial, Sans MS Comics, Thaoma, Verdana, Calibri } 
    if (%lang == it) { xdid -T treebardialog 7 Imposta il Tipo di Carattere. Qualche esempio Arial, Sans MS Comics, Thaoma, Verdana, Calibri }
    if (%lang == es) { xdid -T treebardialog 7 Establece el tipo de carácter. Algunos ejemplos  Arial, Sans MS Comics, Thaoma, Verdana, Calibri }
    if (%lang == fr) { xdid -T treebardialog 7 Définit le type de caractère. Quelques exemples  Arial, Sans MS Comics, Thaoma, Verdana, Calibri }
    xdid -f treebardialog 7 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 7 1
    xdid -l treebardialog 7 %icosize
    xdid -x treebardialog 7 -hmnsvxzo
    xdid -s treebardialog 7 +c 5
    xdid -w treebardialog 7 +ng 0 themes\icons\fonts.ico
    xdid -w treebardialog 7 +hd 0 themes\icons\fonts.ico
    if (%cur_x == ON) /xdid -J treebardialog 7 +f %butt
    /xdid -C treebardialog 7 +b $dcx(GetSystemColor, COLOR_WINDOW)
  }
}

alias size_prev {
  if ($xdialog(treebardialog, 8).isid == $true) { /xdid -h treebardialog 8 +c 5 | /xdialog -d treebardialog 8 }
  ;// Initialising control: mapchars (Button 8)
  if ($xdialog(treebardialog, 8).isid != $true) {
    if (%position == top) /xdialog -c treebardialog 8 button 252 120 36 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == bottom) /xdialog -c treebardialog 8 button 252 120 36 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == left) /xdialog -c treebardialog 8 button 252 120 36 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == right) /xdialog -c treebardialog 8 button 252 120 36 36 tabstop default group tooltips bitmap shadow notheme transparent right
    /xdid -s treebardialog 8 +c 10
    if (%lang == en) { xdid -T treebardialog 8 Sets the size of Character. } 
    if (%lang == it) { xdid -T treebardialog 8 Imposta la dimensione del carattere. }
    if (%lang == es) { xdid -T treebardialog 8 Establece el tamaño del personaje. }
    if (%lang == fr) { xdid -T treebardialog 8 Définit la taille des caractères. }
    xdid -f treebardialog 8 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 8 1
    xdid -l treebardialog 8 %icosize
    xdid -x treebardialog 8 -hmnsvxzo
    xdid -s treebardialog 8 +c 5
    xdid -w treebardialog 8 +ng 0 themes\icons\size.ico
    xdid -w treebardialog 8 +hd 0 themes\icons\size.ico
    if (%cur_x == ON) /xdid -J treebardialog 8 +f %butt
    /xdid -C treebardialog 8 +b $dcx(GetSystemColor, COLOR_WINDOW)
  }
}

;==========================================================================================================;

alias mode_aliased_tree {
  if ($xdialog(treebardialog, 9).isid == $true) /xdialog -d treebardialog  9
  if ($xdialog(treebardialog, 9).isid != $true) {
    ;// Initialising control: anti-aliased (Check 9)
    if (%position == top) xdialog -c treebardialog 9 check 2 160 90 40 tabstop default notheme 
    if (%position == bottom) xdialog -c treebardialog 9 check 2 160 90 40 tabstop default notheme 
    if (%position == left) xdialog -c treebardialog 9 check 2 160 90 40 tabstop default notheme 
    if (%position == right) xdialog -c treebardialog 9 check 2 160 90 40 tabstop default notheme 
    if (%lang == en) { xdid -t treebardialog 9 Aliased | xdid -T treebardialog 9 Sets the anti-aliased character } 
    if (%lang == it) { xdid -t treebardialog 9 Aliased | xdid -T treebardialog 9 Imposta il carattere anti-Aliased }
    if (%lang == es) { xdid -t treebardialog 9 Aliased | xdid -T treebardialog 9 Establece el carácter anti-Aliased }
    if (%lang == fr) { xdid -t treebardialog 9 Aliased | xdid -T treebardialog 9 Définit le caractère anti-Aliased }
    xdid -C treebardialog 9 +b $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C treebardialog 9 +k $dcx(GetSystemColor, COLOR_HIGHLIGHT)
    xdid -C treebardialog 9 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    xdid -f treebardialog 9 +a %xchartree %xdimtree %xcartree
    if (%textmode == +a) /xdid -c treebardialog  9 
    if (%textmode != +a) /xdid -u treebardialog  9
  }
}

alias mode_norm_tree {
  if ($xdialog(treebardialog, 10).isid == $true) /xdialog -d treebardialog  10
  if ($xdialog(treebardialog, 10).isid != $true) {
    ;// Initialising control: Italics (Check 10)
    if (%position == top) xdialog -c treebardialog 10 check 100 160 90 40 tabstop default notheme 
    if (%position == bottom) xdialog -c treebardialog 10 check 100 160 90 40 tabstop default notheme
    if (%position == left) xdialog -c treebardialog 10 check 100 160 90 40 tabstop default notheme 
    if (%position == right) xdialog -c treebardialog 10 check 100 160 90 40 tabstop default notheme
    if (%lang == en) { xdid -t treebardialog 10 Italics | xdid -T treebardialog 10 Sets the Italics character } 
    if (%lang == it) { xdid -t treebardialog 10 Italics | xdid -T treebardialog 10 Imposta il carattere Italics }
    if (%lang == es) { xdid -t treebardialog 10 Italics | xdid -T treebardialog 10 Establece el carácter Italics }
    if (%lang == fr) { xdid -t treebardialog 10 Italics | xdid -T treebardialog 10 Définit le caractère Italics }
    xdid -C treebardialog 10 +b $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C treebardialog 10 +k $dcx(GetSystemColor, COLOR_HIGHLIGHT)
    xdid -C treebardialog 10 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    xdid -f treebardialog 10 +i %xchartree %xdimtree %xcartree
    if (%textmode == +i) /xdid -c treebardialog 10
    if (%textmode != +i) /xdid -u treebardialog 10 
  }
}

alias mode_bold_tree {
  if ($xdialog(treebardialog, 11).isid == $true) /xdialog -d treebardialog 11
  if ($xdialog(treebardialog, 11).isid != $true) {
    ;// Initialising control: Bold (Check 11)
    if (%position == top) xdialog -c treebardialog 11 check 200 160 90 40 tabstop default notheme 
    if (%position == bottom) xdialog -c treebardialog 11 check 200 160 90 40 tabstop default notheme 
    if (%position == left) xdialog -c treebardialog 11 check 200 160 90 40 tabstop default notheme 
    if (%position == right) xdialog -c treebardialog 11 check 200 160 90 40 tabstop default notheme
    if (%lang == en) { xdid -t treebardialog 11 Bold | xdid -T treebardialog 11 Sets the Bold character } 
    if (%lang == it) { xdid -t treebardialog 11 Maiuscolo | xdid -T treebardialog 11 Imposta il carattere maiuscolo }
    if (%lang == es) { xdid -t treebardialog 11 Mayúsculas | xdid -T treebardialog 11 Establece el carácter Mayúsculas }
    if (%lang == fr) { xdid -t treebardialog 11 Majuscule | xdid -T treebardialog 11 Définit le caractère Majuscule }
    xdid -C treebardialog 11 +b $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C treebardialog 11 +k $dcx(GetSystemColor, COLOR_HIGHLIGHT)
    xdid -C treebardialog 11 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%textmode == +bi) /xdid -c treebardialog 11   
    if (%textmode == +ba) /xdid -c treebardialog 11  
    xdid -f treebardialog 11 +b %xchartree %xdimtree %xcartree 
  }
}

alias coloritr {
  if ($xdialog(treebardialog, 30).isid == $true) { /xdid -h treebardialog 30 +c 5 | /xdialog -d treebardialog 30 }
  ;// Initialising control: colori treebar (Button 30)
  if ($xdialog(treebardialog, 30).isid != $true) {
    if (%position == top) /xdialog -c treebardialog 30 button 0 190 200 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == bottom) /xdialog -c treebardialog 30 button 0 190 200 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == left) /xdialog -c treebardialog 30 button 0 190 200 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == right) /xdialog -c treebardialog 30 button 0 190 200 36 tabstop default group tooltips bitmap shadow notheme transparent right
    /xdid -s treebardialog 30 +c 10
    if (%lang == en) { xdid -t treebardialog 30 Treebar Colors | xdid -T treebardialog 30 Treebar Colors }
    if (%lang == it) { xdid -t treebardialog 30 Colori Treebar | xdid -T treebardialog 30 Colori Treebar }
    if (%lang == es) { xdid -t treebardialog 30 color Treebar | xdid -T treebardialog 30 color Treebar }
    if (%lang == fr) { xdid -t treebardialog 30 Couleur treebar | xdid -T treebardialog 30 Couleur treebar }
    xdid -f treebardialog 30 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 30 1
    xdid -l treebardialog 30 %icosize
    xdid -x treebardialog 30 -hmnsvxzo
    xdid -s treebardialog 30 +c 5
    xdid -w treebardialog 30 +ng 0 themes\icons\colors.ico
    xdid -w treebardialog 30 +hd 0 themes\icons\colors.ico
    if (%cur_x == ON) /xdid -J treebardialog 30 +f %butt
    /xdid -C treebardialog 30 +b $dcx(GetSystemColor, COLOR_WINDOW)
  }
}

alias iconetr {
  if ($xdialog(treebardialog, 31).isid == $true) { /xdid -h treebardialog 31 +c 5 | /xdialog -d treebardialog 31 }
  ;// Initialising control: icone treebar (Button 31)
  if ($xdialog(treebardialog, 31).isid != $true) {
    if (%position == top) /xdialog -c treebardialog 31 button 200 190 200 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == bottom) /xdialog -c treebardialog 31 button 200 190 200 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == left) /xdialog -c treebardialog 31 button 0 230 200 36 tabstop default group tooltips bitmap shadow notheme transparent right
    if (%position == right) /xdialog -c treebardialog 31 button 0 230 200 36 tabstop default group tooltips bitmap shadow notheme transparent right
    /xdid -s treebardialog 31 +c 10
    if (%lang == en) { xdid -t treebardialog 31 Icons Treebar | xdid -T treebardialog 31 Icons Treebar }
    if (%lang == it) { xdid -t treebardialog 31 Icone Treebar | xdid -T treebardialog 31 Icone Treebar }
    if (%lang == es) { xdid -t treebardialog 31 Iconos Treebar | xdid -T treebardialog 31 Iconos Treebar }
    if (%lang == fr) { xdid -t treebardialog 31 Icônes treebar | xdid -T treebardialog 31 Icônes Treebar }
    xdid -f treebardialog 31 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 31 1
    xdid -l treebardialog 31 %icosize
    xdid -x treebardialog 31 -hmnsvxzo
    xdid -s treebardialog 31 +c 5
    xdid -w treebardialog 31 +ng 0 themes\icons\folder.ico
    xdid -w treebardialog 31 +hd 0 themes\icons\folder.ico
    if (%cur_x == ON) /xdid -J treebardialog 31 +f %butt
    /xdid -C treebardialog 31 +b $dcx(GetSystemColor, COLOR_WINDOW)
  }
}

alias background_color_tree {
  if ($xdialog(treebardialog, 12).isid == $true) /xdialog -d treebardialog 12
  if ($xdialog(treebardialog, 12).isid != $true) {
    ;// Initialising control: BG (Button 12)
    if (%position == top) xdialog -c treebardialog 12 button 400 2 300 40 tabstop default group tooltips bitmap shadow notheme transparent 
    if (%position == bottom) xdialog -c treebardialog 12 button 400 2 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == left) xdialog -c treebardialog 12 button 2 200 50 40 tabstop default group tooltips bitmap shadow notheme transparent 
    if (%position == right) xdialog -c treebardialog 12 button 2 200 50 40 tabstop default group tooltips bitmap shadow notheme transparent 
    if (%lang == en) { xdid -t treebardialog 12 ██ BackGround | xdid -T treebardialog 12 Back Ground Color } 
    if (%lang == it) { xdid -t treebardialog 12 ██ colore di Fondo | xdid -T treebardialog 12 Colore di Fondo }
    if (%lang == es) { xdid -t treebardialog 12 ██ color de Fondo | xdid -T treebardialog 12 Color de Fondo }
    if (%lang == fr) { xdid -t treebardialog 12 ██ couleur de Fond | xdid -T treebardialog 12 Couleur de Fond }
    xdid -f treebardialog 12 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 12 1
    xdid -C treebardialog 12 +b $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -x treebardialog 12 -hmnsvxzo
    xdid -s treebardialog 12 +c 10
    xdid -c treebardialog 12 +h %treebarbg
    xdid -c treebardialog 12 +d %treebarbg
    xdid -c treebardialog 12 +n %treebarbg
    xdid -c treebardialog 12 +s %treebarbg
    if (%cur_x == ON) xdid -J treebardialog 12 +f %butt
  }
}

alias text_color_tree {
  if ($xdialog(treebardialog, 13).isid == $true) /xdialog -d treebardialog 13
  if ($xdialog(treebardialog, 13).isid != $true) {
    ;// Initialising control: Text color (Button 13)
    if (%position == top) xdialog -c treebardialog 13 button 400 50 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == bottom) xdialog -c treebardialog 13 button 400 50 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == left) xdialog -c treebardialog 13 button 2 240 100 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == right) xdialog -c treebardialog 13 button 2 240 100 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%lang == en) { xdid -t treebardialog 13 ██ Text | xdid -T treebardialog 13 Set Text Color }
    if (%lang == it) { xdid -t treebardialog 13 ██ Testo | xdid -T treebardialog 13 Imposta il colore del testo }
    if (%lang == es) { xdid -t treebardialog 13 ██ Texto | xdid -T treebardialog 13 Ajuste el color de texto }
    if (%lang == fr) { xdid -t treebardialog 13 ██ Texte | xdid -T treebardialog 13 Régler la couleur du texte }
    xdid -f treebardialog 13 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 13 1
    xdid -C treebardialog 13 +b $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -x treebardialog 13 -hmnsvxzo
    xdid -s treebardialog 13 +c 10
    xdid -c treebardialog 13 +h %treetext
    xdid -c treebardialog 13 +d %treetext
    xdid -c treebardialog 13 +n %treetext
    xdid -c treebardialog 13 +s %treetext
    if (%cur_x == ON) /xdid -J treebardialog 13 +f %butt
  }
}

alias line_color_tree {
  if ($xdialog(treebardialog, 14).isid == $true) /xdialog -d treebardialog 14
  if ($xdialog(treebardialog, 14).isid != $true) {
    ;// Initialising control: Line color (Button 14)
    if (%position == top) xdialog -c treebardialog 14 button 400 100 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == bottom) xdialog -c treebardialog 14 button 400 100 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == left) xdialog -c treebardialog 14 button 2 280 150 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == right) xdialog -c treebardialog 14 button 2 280 150 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%lang == en) { xdid -t treebardialog 14 ██ Line | xdid -T treebardialog 14 Set Line Color }   
    if (%lang == it) { xdid -t treebardialog 14 ██ Linea | xdid -T treebardialog 14 Imposta il colore della Linea } 
    if (%lang == es) { xdid -t treebardialog 14 ██ Linea | xdid -T treebardialog 14 establece el color de la Línea } 
    if (%lang == fr) { xdid -t treebardialog 14 ██ Ligne | xdid -T treebardialog 14 définit la couleur de la ligne } 
    xdid -f treebardialog 14 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 14 1
    xdid -C treebardialog 14 +b $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -x treebardialog 14 -hmnsvxzo
    xdid -s treebardialog 14 +c 10
    xdid -c treebardialog 14 +h %treeline
    xdid -c treebardialog 14 +d %treeline
    xdid -c treebardialog 14 +n %treeline
    xdid -c treebardialog 14 +s %treeline
    if (%cur_x == ON) /xdid -J treebardialog 14 +f %butt
  }
}

alias selected_color_tree {
  if ($xdialog(treebardialog, 15).isid == $true) /xdialog -d treebardialog 15
  if ($xdialog(treebardialog, 15).isid != $true) {
    ;// Initialising control: Select BG color (Button 15)
    if (%position == top) xdialog -c treebardialog 15 button 400 150 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == bottom) xdialog -c treebardialog 15 button 400 150 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == left) xdialog -c treebardialog 15 button 2 320 200 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == right) xdialog -c treebardialog 15 button 2 320 200 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%lang == en) { xdid -t treebardialog 15 ██ Selected BG | xdid -T treebardialog 15 Set Selected BG }
    if (%lang == it) { xdid -t treebardialog 15 ██ fondo Selezione | xdid -T treebardialog 15 Imposta il colore sotto il testo selezionato }
    if (%lang == fr) { xdid -t treebardialog 15 ██ Sous Sélectionné | xdid -T treebardialog 15 Définit la couleur sous le texte sélectionné }
    if (%lang == es) { xdid -t treebardialog 15 ██ Bajo Seleccionada | xdid -T treebardialog 15 Establece el color bajo el texto seleccionado }    
    xdid -f treebardialog 15 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 15 1
    /xdid -C treebardialog 15 +b $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -x treebardialog 15 -hmnsvxzo
    xdid -s treebardialog 15 +c 10
    xdid -c treebardialog 15 +h %treetextsb
    xdid -c treebardialog 15 +d %treetextsb
    xdid -c treebardialog 15 +n %treetextsb
    xdid -c treebardialog 15 +s %treetextsb
    if (%cur_x == ON) /xdid -J treebardialog 15 +f %butt
  }
}

alias messagebg_color_tree {
  if ($xdialog(treebardialog, 16).isid == $true) /xdialog -d treebardialog 16
  if ($xdialog(treebardialog, 16).isid != $true) {
    ;// Initialising control: Messages BG Color (Button 16)
    if (%position == top) xdialog -c treebardialog 16 button 700 2 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == bottom) xdialog -c treebardialog 16 button 700 2 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == left) xdialog -c treebardialog 16 button 2 360 250 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == right) xdialog -c treebardialog 16 button 2 360 250 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%lang == en) { xdid -t treebardialog 16 ██ MessagesBG | xdid -T treebardialog 16 Set Messages Background Colors }
    if (%lang == it) { xdid -t treebardialog 16 ██ sotto Messaggio | xdid -T treebardialog 16 Imposta il colore di fondo del Messaggio }
    if (%lang == es) { xdid -t treebardialog 16 ██ Mensajes fondo | xdid -T treebardialog 16 Establece el color de fondo del mensaje }
    if (%lang == fr) { xdid -t treebardialog 16 ██ message fond | xdid -T treebardialog 16 Définit la couleur du message de fond }
    xdid -f treebardialog 16 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 16 1
    /xdid -C treebardialog 16 +b $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -x treebardialog 16 -hmnsvxzo
    xdid -s treebardialog 16 +c 10
    xdid -c treebardialog 16 +h %messagebg
    xdid -c treebardialog 16 +d %messagebg
    xdid -c treebardialog 16 +n %messagebg
    xdid -c treebardialog 16 +s %messagebg
    if (%cur_x == ON) /xdid -J treebardialog 16 +f %butt
  }
}

alias messages_color_tree {
  if ($xdialog(treebardialog, 17).isid == $true) /xdialog -d treebardialog 17
  if ($xdialog(treebardialog, 17).isid != $true) {
    ;// Initialising control: Messages Color (Button 17)
    if (%position == top) xdialog -c treebardialog 17 button 700 50 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == bottom) xdialog -c treebardialog 17 button 700 50 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == left) xdialog -c treebardialog 17 button 2 400 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == right) xdialog -c treebardialog 17 button 2 400 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%lang == en) { xdid -t treebardialog 17 ██ Messages | xdid -T treebardialog 17 Set Messages Colors }
    if (%lang == it) { xdid -t treebardialog 17 ██ Messaggi | xdid -T treebardialog 17 Imposta il colore del Messaggio }
    if (%lang == es) { xdid -t treebardialog 17 ██ Mensajes | xdid -T treebardialog 17 Establece el color del Mensaje }
    if (%lang == fr) { xdid -t treebardialog 17 ██ Messages | xdid -T treebardialog 17 Définit la couleur du message }
    xdid -f treebardialog 17 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 17 1
    /xdid -C treebardialog 17 +b $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -x treebardialog 17 -hmnsvxzo
    xdid -s treebardialog 17 +c 10
    xdid -c treebardialog 17 +h %treemess
    xdid -c treebardialog 17 +d %treemess
    xdid -c treebardialog 17 +n %treemess
    xdid -c treebardialog 17 +s %treemess
    if (%cur_x == ON) /xdid -J treebardialog 17 +f %butt
  }
}

alias hottext_color_tree {
  if ($xdialog(treebardialog, 18).isid == $true) /xdialog -d treebardialog 18
  if ($xdialog(treebardialog, 18).isid != $true) {
    ;// Initialising control: Hot highlight Color (Button 18)
    if (%position == top) xdialog -c treebardialog 18 button 700 100 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == bottom) xdialog -c treebardialog 18 button 700 100 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == left) xdialog -c treebardialog 18 button 2 440 350 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == right) xdialog -c treebardialog 18 button 2 440 350 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%lang == en) { xdid -t treebardialog 18 ██ Highlight Text | xdid -T treebardialog 18 Set Highlight Text Color }
    if (%lang == it) { xdid -t treebardialog 18 ██ Evidenziato | xdid -T treebardialog 18 Imposta il colore in Evidenza }
    if (%lang == es) { xdid -t treebardialog 18 ██ punto Culminante | xdid -T treebardialog 18 Ajuste el color a ver }
    if (%lang == fr) { xdid -t treebardialog 18 ██ Surligner | xdid -T treebardialog 18 Réglez la couleur à Lire }
    xdid -f treebardialog 18 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 18 1
    /xdid -C treebardialog 18 +b $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -x treebardialog 18 -hmnsvxzo
    xdid -s treebardialog 18 +c 10
    xdid -c treebardialog 18 +h %treeh
    xdid -c treebardialog 18 +d %treeh
    xdid -c treebardialog 18 +n %treeh
    xdid -c treebardialog 18 +s %treeh
    if (%cur_x == ON) /xdid -J treebardialog 18 +f %butt
  }
}

alias event_color_tree {
  if ($xdialog(treebardialog, 19).isid == $true) /xdialog -d treebardialog 19
  if ($xdialog(treebardialog, 19).isid != $true) {
    ;// Initialising control: Events (Button 19)
    if (%position == top) xdialog -c treebardialog 19 button 700 150 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == bottom) xdialog -c treebardialog 19 button 700 150 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == left) xdialog -c treebardialog 19 button 2 480 400 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == right) xdialog -c treebardialog 19 button 2 480 400 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%lang == en) { xdid -t treebardialog 19 ██ Events | xdid -T treebardialog 19 Sets Events color } 
    if (%lang == it) { xdid -t treebardialog 19 ██ Eventi | xdid -T treebardialog 19 Imposta il colore Eventi }
    if (%lang == es) { xdid -t treebardialog 19 ██ Eventos | xdid -T treebardialog 19 Establece los Eventos de color }
    if (%lang == fr) { xdid -t treebardialog 19 ██ Événements | xdid -T treebardialog 19 Définit la couleur Événements }
    xdid -f treebardialog 19 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 19 1
    xdid -C treebardialog 19 +b $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -x treebardialog 19 -hmnsvxzo
    xdid -s treebardialog 19 +c 10
    xdid -c treebardialog 19 +h %treevent
    xdid -c treebardialog 19 +d %treevent
    xdid -c treebardialog 19 +n %treevent
    xdid -c treebardialog 19 +s %treevent
    if (%cur_x == ON) xdid -J treebardialog 19 +f %butt
  }
}

alias eventBG_color_tree {
  if ($xdialog(treebardialog, 20).isid == $true) /xdialog -d treebardialog 20
  if ($xdialog(treebardialog, 20).isid != $true) {
    ;// Initialising control: eventBG (Button 20)
    if (%position == top) xdialog -c treebardialog 20 button 900 2 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == bottom) xdialog -c treebardialog 20 button 900 2 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == left) xdialog -c treebardialog 20 button 2 520 450 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == right) xdialog -c treebardialog 20 button 2 520 150 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%lang == en) { xdid -t treebardialog 20 ██ Events BG | xdid -T treebardialog 20 Set Event Background Color } 
    if (%lang == it) { xdid -t treebardialog 20 ██ Eventi fondo | xdid -T treebardialog 20 Imposta il colore di fondo Eventi }
    if (%lang == es) { xdid -t treebardialog 20 ██ Eventos fondo | xdid -T treebardialog 20 Establece el color de fondo de Eventos }
    if (%lang == fr) { xdid -t treebardialog 20 ██ Événements fond | xdid -T treebardialog 20 Définit la couleur de fond des événements }
    xdid -f treebardialog 20 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 20 1
    xdid -C treebardialog 20 +b $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -x treebardialog 20 -hmnsvxzo
    xdid -s treebardialog 20 +c 10
    xdid -c treebardialog 20 +h %treetextevo
    xdid -c treebardialog 20 +d %treetextevo
    xdid -c treebardialog 20 +n %treetextevo
    xdid -c treebardialog 20 +s %treetextevo
    if (%cur_x == ON) xdid -J treebardialog 20 +f %butt
  }
}

alias hot_color_tree {
  if ($xdialog(treebardialog, 21).isid == $true) /xdialog -d treebardialog 21
  if ($xdialog(treebardialog, 21).isid != $true) {
    ;// Initialising control: Hot Text (Button 21)
    if (%position == top) xdialog -c treebardialog 21 button 900 50 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == bottom) xdialog -c treebardialog 21 button 900 50 300 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == left) xdialog -c treebardialog 21 button 2 560 500 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%position == right) xdialog -c treebardialog 21 button 2 560 500 40 tabstop default group tooltips bitmap shadow notheme transparent
    if (%lang == en) { xdid -t treebardialog 21 ██ Hot Text | xdid -T treebardialog 21 Set Hot Text Color } 
    if (%lang == it) { xdid -t treebardialog 21 ██ Testo acceso | xdid -T treebardialog 21 Imposta il colore del Testo acceso }
    if (%lang == es) { xdid -t treebardialog 21 ██ Texto iluminado | xdid -T treebardialog 21 Ajuste el color del Texto iluminado }
    if (%lang == fr) { xdid -t treebardialog 21 ██ Texte éclairés | xdid -T treebardialog 21 Régler la couleur du Texte éclairés }
    xdid -f treebardialog 21 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 21 1
    xdid -C treebardialog 21 +b $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -x treebardialog 21 -hmnsvxzo
    xdid -s treebardialog 21 +c 10
    xdid -c treebardialog 21 +h %treehot
    xdid -c treebardialog 21 +d %treehot
    xdid -c treebardialog 21 +n %treehot
    xdid -c treebardialog 21 +s %treehot
    if (%cur_x == ON) xdid -J treebardialog 21 +f %butt
  }
}

alias icostatus_tree {
  if ($xdialog(treebardialog, 22).isid == $true) /xdialog -d treebardialog 22
  if ($xdialog(treebardialog, 22).isid != $true) {
    ;// Initialising control: STATUS (Button 22)
    if (%position == top) xdialog -c treebardialog 22 button 400 2 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == bottom) xdialog -c treebardialog 22 button 400 2 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == left) xdialog -c treebardialog 22 button 2 600 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == right) xdialog -c treebardialog 22 button 2 600 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%lang == en) { xdid -t treebardialog 22 Status | xdid -T treebardialog 22 Set STATUS window Icon } 
    if (%lang == it) { xdid -t treebardialog 22 Stato | xdid -T treebardialog 22 Imposta icona della finestra di Stato }
    if (%lang == es) { xdid -t treebardialog 22 Estado | xdid -T treebardialog 22 Establece el icono de la ventana Estado }
    if (%lang == fr) { xdid -t treebardialog 22 état | xdid -T treebardialog 22 Définit icône de la fenêtre d'état }
    xdid -f treebardialog 22 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 22 1
    xdid -l treebardialog 22 %icosize
    xdid -x treebardialog 22 -hmnsvxzo
    xdid -s treebardialog 22 +c 10
    xdid -c treebardialog 22 +h $dcx(GetSystemColor, COLOR_HOTLIGHT)
    xdid -c treebardialog 22 +d $dcx(GetSystemColor, COLOR_HIGHLIGHT)
    xdid -c treebardialog 22 +n $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    xdid -c treebardialog 22 +s $dcx(GetSystemColor, COLOR_HIGHLIGHTTEXT)
    xdid -w treebardialog 22 +nhd 0 %icostatus
    if (%cur_x == ON) /xdid -J treebardialog 22 +f %butt
    /xdid -C treebardialog 22 +b %treebarbg
  }
}

alias icocust_tree {
  if ($xdialog(treebardialog, 23).isid == $true) /xdialog -d treebardialog  23
  if ($xdialog(treebardialog, 23).isid != $true) {
    ;// Initialising control: custom (Button 23)
    if (%position == top) xdialog -c treebardialog 23 button 400 50 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == bottom) xdialog -c treebardialog 23 button 400 50 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == left) xdialog -c treebardialog 23 button 2 640 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == right) xdialog -c treebardialog 23 button 2 640 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%lang == en) { xdid -t treebardialog 23 Custom | xdid -T treebardialog 23 Set Custom window Icon } 
    if (%lang == it) { xdid -t treebardialog 23 Personalizzata | xdid -T treebardialog 23 Imposta l' icona della finestra Personalizzata }
    if (%lang == es) { xdid -t treebardialog 23 Personalizado | xdid -T treebardialog 23 Ajuste la "ventana Icono personalizado }
    if (%lang == fr) { xdid -t treebardialog 23 Personnalisée | xdid -T treebardialog 23 Réglez la «fenêtre icône personnalisée }
    xdid -f treebardialog 23 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 23 1
    xdid -l treebardialog 23 %icosize
    xdid -x treebardialog 23 -hmnsvxzo
    xdid -s treebardialog 23 +c 10
    xdid -c treebardialog 23 +h $dcx(GetSystemColor, COLOR_HOTLIGHT)
    xdid -c treebardialog 23 +d $dcx(GetSystemColor, COLOR_HIGHLIGHT)
    xdid -c treebardialog 23 +n $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    xdid -c treebardialog 23 +s $dcx(GetSystemColor, COLOR_HIGHLIGHTTEXT)
    xdid -w treebardialog 23 +nhd 0 %icocust
    if (%cur_x == ON) /xdid -J treebardialog 23 +f %butt
    /xdid -C treebardialog 23 +b %treebarbg
  }
}

alias iconot_tree {
  if ($xdialog(treebardialog, 24).isid == $true) /xdialog -d treebardialog  24
  if ($xdialog(treebardialog, 24).isid != $true) {
    ;// Initialising control: notify (Button 24)
    if (%position == top) xdialog -c treebardialog 24 button 400 100 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == bottom) xdialog -c treebardialog 24 button 400 100 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == left) xdialog -c treebardialog 24 button 2 680 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == right) xdialog -c treebardialog 24 button 2 680 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%lang == en) { xdid -t treebardialog 24 Notify | xdid -T treebardialog 24 Set Notify Icon } 
    if (%lang == it) { xdid -t treebardialog 24 Notifica | xdid -T treebardialog 24 Imposta l' icona della Notifica }
    if (%lang == es) { xdid -t treebardialog 24 Notificación | xdid -T treebardialog 24 Ajuste el 'icono de la Notificación }
    if (%lang == fr) { xdid -t treebardialog 24 Notification | xdid -T treebardialog 24 Réglez le 'icône de la notification }
    xdid -f treebardialog 24 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 24 1
    xdid -l treebardialog 24 %icosize
    xdid -x treebardialog 24 -hmnsvxzo
    xdid -s treebardialog 24 +c 10
    xdid -c treebardialog 24 +h $dcx(GetSystemColor, COLOR_HOTLIGHT)
    xdid -c treebardialog 24 +d $dcx(GetSystemColor, COLOR_HIGHLIGHT)
    xdid -c treebardialog 24 +n $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    xdid -c treebardialog 24 +s $dcx(GetSystemColor, COLOR_HIGHLIGHTTEXT)
    xdid -w treebardialog 24 +nhd 0 %iconot
    if (%cur_x == ON) /xdid -J treebardialog 24 +f %butt
    /xdid -C treebardialog 24 +b %treebarbg
  }
}

alias icoq_tree {
  if ($xdialog(treebardialog, 25).isid == $true) /xdialog -d treebardialog  25
  if ($xdialog(treebardialog, 25).isid != $true) {
    ;// Initialising control: query (Button 25)
    if (%position == top) xdialog -c treebardialog 25 button 400 150 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == bottom) xdialog -c treebardialog 25 button 400 150 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == left) xdialog -c treebardialog 25 button 2 720 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == right) xdialog -c treebardialog 25 button 2 720 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%lang == en) { xdid -t treebardialog 25 Query | xdid -T treebardialog 25 Set Query Icon } 
    if (%lang == it) { xdid -t treebardialog 25 Query | xdid -T treebardialog 25 Imposta l' icona della Query }
    if (%lang == es) { xdid -t treebardialog 25 Query | xdid -T treebardialog 25 Ajuste el 'icono de la Query }
    if (%lang == fr) { xdid -t treebardialog 25 Query | xdid -T treebardialog 25 Réglez le 'icône de la Query }
    xdid -f treebardialog 25 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 25 1
    xdid -l treebardialog 25 %icosize
    xdid -x treebardialog 25 -hmnsvxzo
    xdid -s treebardialog 25 +c 10
    xdid -c treebardialog 25 +h $dcx(GetSystemColor, COLOR_HOTLIGHT)
    xdid -c treebardialog 25 +d $dcx(GetSystemColor, COLOR_HIGHLIGHT)
    xdid -c treebardialog 25 +n $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    xdid -c treebardialog 25 +s $dcx(GetSystemColor, COLOR_HIGHLIGHTTEXT)
    xdid -w treebardialog 25 +nhd 0 %icoq
    if (%cur_x == ON) /xdid -J treebardialog 25 +f %butt
    /xdid -C treebardialog 25 +b %treebarbg
  }
}

alias icochan_tree {
  if ($xdialog(treebardialog, 26).isid == $true) /xdialog -d treebardialog  26
  if ($xdialog(treebardialog, 26).isid != $true) {
    ;// Initialising control: chan (Button 26)
    if (%position == top) xdialog -c treebardialog 26 button 700 2 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == bottom) xdialog -c treebardialog 26 button 700 2 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == left) xdialog -c treebardialog 26 button 2 760 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == right) xdialog -c treebardialog 26 button 2 760 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%lang == en) { xdid -t treebardialog 26 Channel | xdid -T treebardialog 26 Set Channel Icon } 
    if (%lang == it) { xdid -t treebardialog 26 Canale | xdid -T treebardialog 26 Imposta icona del Canale }
    if (%lang == es) { xdid -t treebardialog 26 Canal | xdid -T treebardialog 26 Ajuste el icono de la Canal }
    if (%lang == fr) { xdid -t treebardialog 26 Canal | xdid -T treebardialog 26 Réglez le icône de la Canal }
    xdid -f treebardialog 26 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 26 1
    xdid -l treebardialog 26 %icosize
    xdid -x treebardialog 26 -hmnsvxzo
    xdid -s treebardialog 26 +c 10
    xdid -c treebardialog 26 +h $dcx(GetSystemColor, COLOR_HOTLIGHT)
    xdid -c treebardialog 26 +d $dcx(GetSystemColor, COLOR_HIGHLIGHT)
    xdid -c treebardialog 26 +n $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    xdid -c treebardialog 26 +s $dcx(GetSystemColor, COLOR_HIGHLIGHTTEXT)
    xdid -w treebardialog 26 +nhd 0 %icochan
    if (%cur_x == ON) /xdid -J treebardialog 26 +f %butt
    /xdid -C treebardialog 26 +b %treebarbg
  }
}


alias icosend_tree {
  if ($xdialog(treebardialog, 27).isid == $true) /xdialog -d treebardialog  27
  if ($xdialog(treebardialog, 27).isid != $true) {
    ;// Initialising control: chan (Button 27)
    if (%position == top) xdialog -c treebardialog 27 button 700 50 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == bottom) xdialog -c treebardialog 27 button 700 50 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == left) xdialog -c treebardialog 27 button 2 800 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == right) xdialog -c treebardialog 27 button 2 800 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%lang == en) { xdid -t treebardialog 27 Send | xdid -T treebardialog 27 Set Send Icon } 
    if (%lang == it) { xdid -t treebardialog 27 Inviati | xdid -T treebardialog 27 Imposta l' icona dei file Inviati }
    if (%lang == es) { xdid -t treebardialog 27 Enviado | xdid -T treebardialog 27 Ajuste el 'icono del archivo Enviado }
    if (%lang == fr) { xdid -t treebardialog 27 Envoyé | xdid -T treebardialog 27 Réglez le 'icône du fichier Envoyé }
    xdid -f treebardialog 27 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 27 1
    xdid -l treebardialog 27 %icosize
    xdid -x treebardialog 27 -hmnsvxzo
    xdid -s treebardialog 27 +c 10
    xdid -c treebardialog 27 +h $dcx(GetSystemColor, COLOR_HOTLIGHT)
    xdid -c treebardialog 27 +d $dcx(GetSystemColor, COLOR_HIGHLIGHT)
    xdid -c treebardialog 27 +n $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    xdid -c treebardialog 27 +s $dcx(GetSystemColor, COLOR_HIGHLIGHTTEXT)
    xdid -w treebardialog 27 +nhd 0 %icosend
    if (%cur_x == ON) /xdid -J treebardialog 27 +f %butt
    /xdid -C treebardialog 27 +b %treebarbg
  }
}

alias icoget_tree {
  if ($xdialog(treebardialog, 28).isid == $true) /xdialog -d treebardialog  28
  if ($xdialog(treebardialog, 28).isid != $true) {
    ;// Initialising control: chan (Button 28)
    if (%position == top) xdialog -c treebardialog 28 button 700 100 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == bottom) xdialog -c treebardialog 28 button 700 100 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == left) xdialog -c treebardialog 28 button 2 840 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == right) xdialog -c treebardialog 28 button 2 840 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%lang == en) { xdid -t treebardialog 28 Get | xdid -T treebardialog 28 Set Get Icon } 
    if (%lang == it) { xdid -t treebardialog 28 Ricevuti | xdid -T treebardialog 28 Imposta l' icona dei file Ricevuti }
    if (%lang == es) { xdid -t treebardialog 28 Recibido | xdid -T treebardialog 28 Ajuste el 'icono del archivo Recibito }
    if (%lang == fr) { xdid -t treebardialog 28 Reçu | xdid -T treebardialog 28 Réglez le 'icône du fichier Reçu }
    xdid -f treebardialog 28 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 28 1
    xdid -l treebardialog 28 %icosize
    xdid -x treebardialog 28 -hmnsvxzo
    xdid -s treebardialog 28 +c 10
    xdid -c treebardialog 28 +h $dcx(GetSystemColor, COLOR_HOTLIGHT)
    xdid -c treebardialog 28 +d $dcx(GetSystemColor, COLOR_HIGHLIGHT)
    xdid -c treebardialog 28 +n $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    xdid -c treebardialog 28 +s $dcx(GetSystemColor, COLOR_HIGHLIGHTTEXT)
    xdid -w treebardialog 28 +nhd 0 %icoget
    if (%cur_x == ON) /xdid -J treebardialog 28 +f %butt
    /xdid -C treebardialog 28 +b %treebarbg
  }
}


alias icodir_tree {
  if ($xdialog(treebardialog, 29).isid == $true) /xdialog -d treebardialog  29
  if ($xdialog(treebardialog, 29).isid != $true) {
    ;// Initialising control: chan (Button 29)
    if (%position == top) xdialog -c treebardialog 29 button 700 150 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == bottom) xdialog -c treebardialog 29 button 700 150 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == left) xdialog -c treebardialog 29 button 2 880 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%position == right) xdialog -c treebardialog 29 button 2 880 300 40 tabstop group default tooltips notheme transparent shadow bitmap left
    if (%lang == en) { xdid -t treebardialog 29 Folder | xdid -T treebardialog 29 Set the Folder icon file } 
    if (%lang == it) { xdid -t treebardialog 29 Cartella | xdid -T treebardialog 29 Imposta l'icona della Cartella file }
    if (%lang == es) { xdid -t treebardialog 29 Carpeta | xdid -T treebardialog 29 Establezca el icono del archivo Carpeta }
    if (%lang == fr) { xdid -t treebardialog 29 Dossier | xdid -T treebardialog 29 Réglez le fichier de l'icône dossier }
    xdid -f treebardialog 29 %textmode %xchartree %xdimtree %xcartree
    xdid -m treebardialog 29 1
    xdid -l treebardialog 29 %icosize
    xdid -x treebardialog 29 -hmnsvxzo
    xdid -s treebardialog 29 +c 10
    xdid -c treebardialog 29 +h $dcx(GetSystemColor, COLOR_HOTLIGHT)
    xdid -c treebardialog 29 +d $dcx(GetSystemColor, COLOR_HIGHLIGHT)
    xdid -c treebardialog 29 +n $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    xdid -c treebardialog 29 +s $dcx(GetSystemColor, COLOR_HIGHLIGHTTEXT)
    xdid -w treebardialog 29 +nhd 0 %icodir
    if (%cur_x == ON) /xdid -J treebardialog 29 +f %butt
    /xdid -C treebardialog 29 +b %treebarbg
  }
}

alias cla_tree_lr {
  xdialog -l treebardialog root $chr(9) +plv 0 0 0 0
  xdialog -l treebardialog cell root $chr(9) +plv 0 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +ilp 1 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +ilp 2 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +ilp 3 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +ilp 4 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +ilp 5 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +ilp 6 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +lip 7 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +lip 8 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +lip 9 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +lip 10 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +lip 11 1 0 0 
  xdialog -l treebardialog cell 1 $chr(9) +lip 30 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +lip 31 1 0 0

  if ($xdialog(treebardialog, 12).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +li 12 1 0 0
  if ($xdialog(treebardialog, 13).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +li 13 1 0 0
  if ($xdialog(treebardialog, 14).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +li 14 1 0 0
  if ($xdialog(treebardialog, 15).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +li 15 1 0 0
  if ($xdialog(treebardialog, 16).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +li 16 1 0 0
  if ($xdialog(treebardialog, 17).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +li 17 1 0 0
  if ($xdialog(treebardialog, 18).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +li 18 1 0 0
  if ($xdialog(treebardialog, 19).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +li 19 1 0 0
  if ($xdialog(treebardialog, 20).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +li 20 1 0 0
  if ($xdialog(treebardialog, 21).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +li 21 1 0 0

  if ($xdialog(treebardialog, 22).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +li 22 1 0 0
  if ($xdialog(treebardialog, 23).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +li 23 1 0 0
  if ($xdialog(treebardialog, 24).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +li 24 1 0 0
  if ($xdialog(treebardialog, 25).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +li 25 1 0 0
  if ($xdialog(treebardialog, 26).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +li 26 1 0 0
  if ($xdialog(treebardialog, 27).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +li 27 1 0 0
  if ($xdialog(treebardialog, 28).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +li 28 1 0 0
  if ($xdialog(treebardialog, 29).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +li 29 1 0 0
}

alias cla_tree_tb {
  xdialog -l treebardialog root $chr(9) +phv 0 0 0 0
  xdialog -l treebardialog cell root $chr(9) +phv 0 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +ilp 1 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +ilp 2 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +ilp 3 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +ilp 4 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +ilp 5 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +ilp 6 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +lip 7 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +lip 8 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +lip 9 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +lip 10 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +lip 11 1 0 0 
  xdialog -l treebardialog cell 1 $chr(9) +lip 30 1 0 0
  xdialog -l treebardialog cell 1 $chr(9) +lip 31 1 0 0

  if ($xdialog(treebardialog, 12).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +lip 12 1 0 0
  if ($xdialog(treebardialog, 13).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +lip 13 1 0 0
  if ($xdialog(treebardialog, 14).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +lip 14 1 0 0
  if ($xdialog(treebardialog, 15).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +lip 15 1 0 0
  if ($xdialog(treebardialog, 16).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +lip 16 1 0 0
  if ($xdialog(treebardialog, 17).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +lip 17 1 0 0
  if ($xdialog(treebardialog, 18).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +lip 18 1 0 0
  if ($xdialog(treebardialog, 19).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +lip 19 1 0 0
  if ($xdialog(treebardialog, 20).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +lip 20 1 0 0
  if ($xdialog(treebardialog, 21).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +lip 21 1 0 0

  if ($xdialog(treebardialog, 22).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +lip 22 1 0 0
  if ($xdialog(treebardialog, 23).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +lip 23 1 0 0
  if ($xdialog(treebardialog, 24).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +lip 24 1 0 0
  if ($xdialog(treebardialog, 25).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +lip 25 1 0 0
  if ($xdialog(treebardialog, 26).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +lip 26 1 0 0
  if ($xdialog(treebardialog, 27).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +lip 27 1 0 0
  if ($xdialog(treebardialog, 28).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +lip 28 1 0 0
  if ($xdialog(treebardialog, 29).isid == $true) xdialog -l treebardialog cell 1 $chr(9) +lip 29 1 0 0
}


;===========================================================================================================================;
; menu charset | VxD ~ caronte.ade@gmail.com ~ www.vxd.altervista.org ~ vxd.altervista.org ~ http://vxd.altervista.org                    ;
;===========================================================================================================================;
alias char_set {
  dialog -ma char_set char_set_table
  /xdialog -b char_set -hmnsvxzo
  /xdialog -R char_set +s $dcx(GetSystemColor, COLOR_WINDOW)
  cla_char
  .timer 1 0 xdialog -l char_set update
}

dialog char_set_table {
  title "char_set"
  size %pos_or %pos_vr %pos_lr %pos_lu
}

on *:dialog:char_set:*:*: {
  if ($devent == init) {
    /dcx Mark $dname char_set_cb  
    /xdialog -V $dname %pos_or %pos_vr %pos_lr %pos_lu
    /xdialog -t $dname transparentcolor none
    /xdialog -t $dname alpha none
    /xdialog -g $dname +b $dcx(GetSystemColor, COLOR_WINDOW)
    /xdialog -T $dname +bp 
    /xdialog -t $dname bgcolor $dcx(GetSystemColor, COLOR_WINDOW)
    if (%cur_x == ON) /xdialog -q $dname +f %cursore 
    !if (!$dcx(IsUsingDirectX)) {
      /echo -a DirectX Is Disabled.
      halt
    }
    ;// Call initilisation alias
    char_set_init_dcx
  }
}

alias -l char_set_init_dcx {
  if (%position == left) { .timer 1 0 /xdock -m $dialog(char_set).hwnd +l | /xdialog -a $dname +so 100 }
  if (%position == right) { .timer 1 0 /xdock -m $dialog(char_set).hwnd +r | /xdialog -a $dname +sn 100 }
  if (%position == top) { .timer 1 0 /xdock -m $dialog(char_set).hwnd +t | /xdialog -a $dname +sv 100 }
  if (%position == bottom) { .timer 1 0 /xdock -m $dialog(char_set).hwnd +b |  /xdialog -a $dname +su 100 }
  charsetmenu 
}


;// Callback alias for char_set
alias char_set_cb {
  if ($2 != mouse) { ; echo $color(info) -s */ char_set_cb: $1- }
  if ($2 == sclick) {
    if ($3 == 1) { /set %xchartree ansi | .timer 1 0 refresh_char_list | ref_text | xdialog -x char_set }
    elseif ($3 == 2) { /set %xchartree baltic | .timer 1 0 refresh_char_list | ref_text | xdialog -x char_set }
    elseif ($3 == 3) { /set %xchartree chinesebig | .timer 1 0 refresh_char_list | ref_text | xdialog -x char_set }
    elseif ($3 == 4) { /set %xchartree default | .timer 1 0 refresh_char_list | ref_text | xdialog -x char_set }
    elseif ($3 == 5) { /set %xchartree easteurope | .timer 1 0 refresh_char_list | ref_text | xdialog -x char_set }
    elseif ($3 == 6) { /set %xchartree gb2312 | .timer 1 0 refresh_char_list | ref_text | xdialog -x char_set }
    elseif ($3 == 7) { /set %xchartree greek | .timer 1 0 refresh_char_list | ref_text | xdialog -x char_set }
    elseif ($3 == 8) { /set %xchartree hangul | .timer 1 0 refresh_char_list | ref_text | xdialog -x char_set }
    elseif ($3 == 9) { /set %xchartree mac | .timer 1 0 refresh_char_list | ref_text | xdialog -x char_set }
    elseif ($3 == 10) { /set %xchartree oem | .timer 1 0 refresh_char_list | ref_text | xdialog -x char_set }
    elseif ($3 == 11) { /set %xchartree russian | .timer 1 0 refresh_char_list | ref_text | xdialog -x char_set }
    elseif ($3 == 12) { /set %xchartree shiftjis | .timer 1 0 refresh_char_list | ref_text | xdialog -x char_set }
    elseif ($3 == 13) { /set %xchartree symbol | .timer 1 0 refresh_char_list | ref_text | xdialog -x char_set }
    elseif ($3 == 14) { /set %xchartree turkish | .timer 1 0 refresh_char_list | ref_text | xdialog -x char_set }
    elseif ($3 == 15) { /set %xchartree vietnamese | .timer 1 0 refresh_char_list | ref_text | xdialog -x char_set }
    elseif ($3 == 16) { /set %xchartree italic | .timer 1 0 refresh_char_list | ref_text | xdialog -x char_set } 
  }
}

alias refresh_char_list { 
  .timer 1 0 xdid -r treebardialog 3
  .timer 1 0 xdid -r treebardialog 4
  .timer 1 0 xdid -r treebardialog 5
  /xdid -E treebardialog 3 CharSet $+   %xchartree 
  /xdid -E treebardialog 4 FontName $+   %xcartree 
  /xdid -E treebardialog 5 Size $+   %xdimtree
}

alias charsetmenu {
  if ($xdialog(char_set, 1).isid == $true) /xdialog -d char_set 1
  if ($xdialog(char_set, 1).isid != $true) {
    ;// Initialising control: ansi (Text 1)
    xdialog -c char_set 1 text 2 0 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t char_set 1 ansi | xdid -T char_set 1 Sets the ANSI character Set } 
    if (%lang == it) { xdid -t char_set 1 ansi | xdid -T char_set 1 Imposta il set di caratteri ANSI }
    if (%lang == es) { xdid -t char_set 1 ansi | xdid -T char_set 1 Establece el conjunto de caracteres ANSI }
    if (%lang == fr) { xdid -t char_set 1 ansi | xdid -T char_set 1 Définit le Table des caractères ANSI }   
    xdid -f char_set 1 %textmode ansi %xdimtree %xcartree
    xdid -C char_set 1 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C char_set 1 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J char_set 1 +f %butt
  }
  if ($xdialog(char_set, 2).isid == $true) /xdialog -d char_set 2
  if ($xdialog(char_set, 2).isid != $true) {
    ;// Initialising control: baltic (Text 2)
    xdialog -c char_set 2 text 2 40 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t char_set 2 Baltic | xdid -T char_set 2 Sets the Baltic character Set } 
    if (%lang == it) { xdid -t char_set 2 Baltic | xdid -T char_set 2 Imposta il set di caratteri Baltic }
    if (%lang == es) { xdid -t char_set 2 Baltic | xdid -T char_set 2 Establece el conjunto de caracteres Baltic }
    if (%lang == fr) { xdid -t char_set 2 Baltic | xdid -T char_set 2 Définit le Table des caractères Baltic }
    xdid -f char_set 2 %textmode baltic %xdimtree %xcartree
    xdid -C char_set 2 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C char_set 2 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J char_set 2 +f %butt
  }
  if ($xdialog(char_set, 3).isid == $true) /xdialog -d char_set 3
  if ($xdialog(char_set, 3).isid != $true) {
    ;// Initialising control: chinesebig (Text 3)
    xdialog -c char_set 3 text 2 80 200 40 tabstop default group tooltips bitmap shadow notheme transparent center  
    if (%lang == en) { xdid -t char_set 3 chinesebig | xdid -T char_set 3 Sets the chinesebig character Set } 
    if (%lang == it) { xdid -t char_set 3 chinesebig | xdid -T char_set 3 Imposta il set di caratteri chinesebig }
    if (%lang == es) { xdid -t char_set 3 chinesebig | xdid -T char_set 3 Establece el conjunto de caracteres chinesebig }
    if (%lang == fr) { xdid -t char_set 3 chinesebig | xdid -T char_set 3 Définit le Table des caractères chinesebig }
    xdid -f char_set 3 %textmode chinesebig %xchartree %xdimtree %xcartree
    xdid -C char_set 3 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C char_set 3 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J char_set 3 +f %butt
  }
  if ($xdialog(char_set, 4).isid == $true) /xdialog -d char_set 4
  if ($xdialog(char_set, 4).isid != $true) {
    ;// Initialising control: default (Text 4)
    xdialog -c char_set 4 text 2 120 200 40 tabstop default group tooltips bitmap shadow notheme transparent center 
    if (%lang == en) { xdid -t char_set 4 default | xdid -T char_set 4 Sets the default character Set } 
    if (%lang == it) { xdid -t char_set 4 default | xdid -T char_set 4 Imposta il set di caratteri default }
    if (%lang == es) { xdid -t char_set 4 default | xdid -T char_set 4 Establece el conjunto de caracteres default }
    if (%lang == fr) { xdid -t char_set 4 default | xdid -T char_set 4 Définit le Table des caractères default } 
    xdid -f char_set 4 %textmode default %xdimtree %xcartree
    xdid -C char_set 4 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C char_set 4 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J char_set 4 +f %butt
  }
  if ($xdialog(char_set, 5).isid == $true) /xdialog -d char_set 5
  if ($xdialog(char_set, 5).isid != $true) {
    ;// Initialising control: easteurope (Text 5)
    xdialog -c char_set 5 text 2 160 200 40 tabstop default group tooltips bitmap shadow notheme transparent center   
    if (%lang == en) { xdid -t char_set 5 easteurope | xdid -T char_set 5 Sets the easteurope character Set } 
    if (%lang == it) { xdid -t char_set 5 easteurope | xdid -T char_set 5 Imposta il set di caratteri easteurope }
    if (%lang == es) { xdid -t char_set 5 easteurope | xdid -T char_set 5 Establece el conjunto de caracteres easteurope }
    if (%lang == fr) { xdid -t char_set 5 easteurope | xdid -T char_set 5 Définit le Table des caractères easteurope }
    xdid -f char_set 5 %textmode easteurope %xdimtree %xcartree
    xdid -C char_set 5 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C char_set 5 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J char_set 5 +f %butt
  }
  if ($xdialog(char_set, 6).isid == $true) /xdialog -d char_set 6
  if ($xdialog(char_set, 6).isid != $true) {
    ;// Initialising control: gb2312 (Text 6)
    xdialog -c char_set 6 text 2 200 200 40 tabstop default group tooltips bitmap shadow notheme transparent center  
    if (%lang == en) { xdid -t char_set 6 gb2312 | xdid -T char_set 6 Sets the gb2312 character Set } 
    if (%lang == it) { xdid -t char_set 6 gb2312 | xdid -T char_set 6 Imposta il set di caratteri gb2312 }
    if (%lang == es) { xdid -t char_set 6 gb2312 | xdid -T char_set 6 Establece el conjunto de caracteres gb2312 }
    if (%lang == fr) { xdid -t char_set 6 gb2312 | xdid -T char_set 6 Définit le Table des caractères gb2312 }
    xdid -f char_set 6 %textmode gb2312 %xdimtree %xcartree
    xdid -C char_set 6 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C char_set 6 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J char_set 6 +f %butt
  }
  if ($xdialog(char_set, 7).isid == $true) /xdialog -d char_set 7
  if ($xdialog(char_set, 7).isid != $true) {
    ;// Initialising control: greek (Text 7)
    xdialog -c char_set 7 text 2 240 200 40 tabstop default group tooltips bitmap shadow notheme transparent center    
    if (%lang == en) { xdid -t char_set 7 greek | xdid -T char_set 7 Sets the greek character Set } 
    if (%lang == it) { xdid -t char_set 7 greek | xdid -T char_set 7 Imposta il set di caratteri greek }
    if (%lang == es) { xdid -t char_set 7 greek | xdid -T char_set 7 Establece el conjunto de caracteres greek }
    if (%lang == fr) { xdid -t char_set 7 greek | xdid -T char_set 7 Définit le Table des caractères greek }   
    xdid -f char_set 7 %textmode greek %xdimtree %xcartree
    xdid -C char_set 7 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C char_set 7 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J char_set 7 +f %butt
  }
  if ($xdialog(char_set, 8).isid == $true) /xdialog -d char_set 8
  if ($xdialog(char_set, 8).isid != $true) {
    ;// Initialising control: hangul (Text 8)
    xdialog -c char_set 8 text 2 280 200 40 tabstop default group tooltips bitmap shadow notheme transparent center  
    if (%lang == en) { xdid -t char_set 8 hangul | xdid -T char_set 8 Sets the hangul character Set } 
    if (%lang == it) { xdid -t char_set 8 hangul | xdid -T char_set 8 Imposta il set di caratteri hangul }
    if (%lang == es) { xdid -t char_set 8 hangul | xdid -T char_set 8 Establece el conjunto de caracteres hangul }
    if (%lang == fr) { xdid -t char_set 8 hangul | xdid -T char_set 8 Définit le Table des caractères hangul }
    xdid -f char_set 8 %textmode hangul %xdimtree %xcartree
    xdid -C char_set 8 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C char_set 8 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J char_set 8 +f %butt
  }
  if ($xdialog(char_set, 9).isid == $true) /xdialog -d char_set 9
  if ($xdialog(char_set, 9).isid != $true) {
    ;// Initialising control: mac (Text 9)
    xdialog -c char_set 9 text 2 320 200 40 tabstop default group tooltips bitmap shadow notheme transparent center  
    if (%lang == en) { xdid -t char_set 9 mac | xdid -T char_set 9 Sets the mac character Set } 
    if (%lang == it) { xdid -t char_set 9 mac | xdid -T char_set 9 Imposta il set di caratteri mac }
    if (%lang == es) { xdid -t char_set 9 mac | xdid -T char_set 9 Establece el conjunto de caracteres mac }
    if (%lang == fr) { xdid -t char_set 9 mac | xdid -T char_set 9 Définit le Table des caractères mac }
    xdid -f char_set 9 %textmode mac %xdimtree %xcartree
    xdid -C char_set 9 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C char_set 9 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J char_set 9 +f %butt
  }
  if ($xdialog(char_set, 10).isid == $true) /xdialog -d char_set 10
  if ($xdialog(char_set, 10).isid != $true) {
    ;// Initialising control: oem (Text 10)
    xdialog -c char_set 10 text 2 360 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t char_set 10 oem | xdid -T char_set 10 Sets the oem character Set } 
    if (%lang == it) { xdid -t char_set 10 oem | xdid -T char_set 10 Imposta il set di caratteri oem }
    if (%lang == es) { xdid -t char_set 10 oem | xdid -T char_set 10 Establece el conjunto de caracteres oem }
    if (%lang == fr) { xdid -t char_set 10 oem | xdid -T char_set 10 Définit le Table des caractères oem }
    xdid -f char_set 10 %textmode oem %xdimtree %xcartree
    xdid -C char_set 10 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C char_set 10 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J char_set 10 +f %butt
  }
  if ($xdialog(char_set, 11).isid == $true) /xdialog -d char_set 11
  if ($xdialog(char_set, 11).isid != $true) {
    ;// Initialising control: russian (Text 11)
    xdialog -c char_set 11 text 2 400 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t char_set 11 russian | xdid -T char_set 11 Sets the russian character Set } 
    if (%lang == it) { xdid -t char_set 11 russian | xdid -T char_set 11 Imposta il set di caratteri russian }
    if (%lang == es) { xdid -t char_set 11 russian | xdid -T char_set 11 Establece el conjunto de caracteres russian }
    if (%lang == fr) { xdid -t char_set 11 russian | xdid -T char_set 11 Définit le Table des caractères russian }   
    xdid -f char_set 11 %textmode russian %xdimtree %xcartree
    xdid -C char_set 11 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C char_set 11 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J char_set 11 +f %butt
  }
  if ($xdialog(char_set, 12).isid == $true) /xdialog -d char_set 12
  if ($xdialog(char_set, 12).isid != $true) {
    ;// Initialising control: shiftjis (Text 12)
    xdialog -c char_set 12 text 2 440 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t char_set 12 chinesebig | xdid -T char_set 12 Sets the chinesebig character Set } 
    if (%lang == it) { xdid -t char_set 12 chinesebig | xdid -T char_set 12 Imposta il set di caratteri chinesebig }
    if (%lang == es) { xdid -t char_set 12 chinesebig | xdid -T char_set 12 Establece el conjunto de caracteres chinesebig }
    if (%lang == fr) { xdid -t char_set 12 chinesebig | xdid -T char_set 12 Définit le Table des caractères chinesebig } 
    xdid -f char_set 12 %textmode shiftjis %xdimtree %xcartree
    xdid -C char_set 12 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C char_set 12 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J char_set 12 +f %butt
  }
  if ($xdialog(char_set, 13).isid == $true) /xdialog -d char_set 13
  if ($xdialog(char_set, 13).isid != $true) {
    ;// Initialising control: symbol (Text 13)
    xdialog -c char_set 13 text 2 480 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t char_set 13 symbol | xdid -T char_set 13 Sets the symbol character Set } 
    if (%lang == it) { xdid -t char_set 13 symbol | xdid -T char_set 13 Imposta il set di caratteri symbol }
    if (%lang == es) { xdid -t char_set 13 symbol | xdid -T char_set 13 Establece el conjunto de caracteres symbol }
    if (%lang == fr) { xdid -t char_set 13 symbol | xdid -T char_set 13 Définit le Table des caractères symbol }
    xdid -f char_set 13 %textmode symbol %xdimtree %xcartree
    xdid -C char_set 13 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C char_set 13 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J char_set 13 +f %butt
  }
  if ($xdialog(char_set, 14).isid == $true) /xdialog -d char_set 14
  if ($xdialog(char_set, 14).isid != $true) {
    ;// Initialising control: turkish (Text 14)
    xdialog -c char_set 14 text 2 520 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t char_set 14 turkish | xdid -T char_set 14 Sets the turkish character Set } 
    if (%lang == it) { xdid -t char_set 14 turkish | xdid -T char_set 14 Imposta il set di caratteri turkish }
    if (%lang == es) { xdid -t char_set 14 turkish | xdid -T char_set 14 Establece el conjunto de caracteres turkish }
    if (%lang == fr) { xdid -t char_set 14 turkish | xdid -T char_set 14 Définit le Table des caractères turkish }
    xdid -f char_set 14 %textmode turkish %xdimtree %xcartree
    xdid -C char_set 14 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C char_set 14 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J char_set 14 +f %butt
  }
  if ($xdialog(char_set, 15).isid == $true) /xdialog -d char_set 15
  if ($xdialog(char_set, 15).isid != $true) {
    ;// Initialising control: vietnamese (Text 15)
    xdialog -c char_set 15 text 2 560 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t char_set 15 vietnamese | xdid -T char_set 15 Sets the vietnamese character Set } 
    if (%lang == it) { xdid -t char_set 15 vietnamese | xdid -T char_set 15 Imposta il set di caratteri vietnamese }
    if (%lang == es) { xdid -t char_set 15 vietnamese | xdid -T char_set 15 Establece el conjunto de caracteres vietnamese }
    if (%lang == fr) { xdid -t char_set 15 vietnamese | xdid -T char_set 15 Définit le Table des caractères vietnamese }
    xdid -f char_set 15 %textmode vietnamese %xdimtree %xcartree
    xdid -C char_set 15 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C char_set 15 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J char_set 15 +f %butt
  }
  if ($xdialog(char_set, 16).isid == $true) /xdialog -d char_set 16
  if ($xdialog(char_set, 16).isid != $true) {
    ;// Initialising control: italic (Text 16)
    xdialog -c char_set 16 text 2 600 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t char_set 16 italic | xdid -T char_set 16 Sets the italic character Set } 
    if (%lang == it) { xdid -t char_set 16 italic | xdid -T char_set 16 Imposta il set di caratteri italic }
    if (%lang == es) { xdid -t char_set 16 italic | xdid -T char_set 16 Establece el conjunto de caracteres italic }
    if (%lang == fr) { xdid -t char_set 16 italic | xdid -T char_set 16 Définit le Table des caractères italic }
    xdid -f char_set 16 %textmode italic %xdimtree %xcartree
    xdid -C char_set 16 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C char_set 16 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J char_set 16 +f %butt
  }
}

alias cla_char {
  xdialog -l char_set root $chr(9) +plvh 0 0 0 0
  xdialog -l char_set cell root $chr(9) +pv 0 1 0 0
  xdialog -l char_set cell 1 $chr(9) +il 1 1 0 0
  xdialog -l char_set cell 1 $chr(9) +il 2 1 0 0
  xdialog -l char_set cell 1 $chr(9) +il 3 1 0 0
  xdialog -l char_set cell 1 $chr(9) +il 4 1 0 0
  xdialog -l char_set cell 1 $chr(9) +il 5 1 0 0
  xdialog -l char_set cell 1 $chr(9) +il 6 1 0 0
  xdialog -l char_set cell 1 $chr(9) +il 7 1 0 0
  xdialog -l char_set cell 1 $chr(9) +il 8 1 0 0
  xdialog -l char_set cell 1 $chr(9) +il 9 1 0 0
  xdialog -l char_set cell 1 $chr(9) +il 10 1 0 0
  xdialog -l char_set cell 1 $chr(9) +il 11 1 0 0
  xdialog -l char_set cell 1 $chr(9) +il 12 1 0 0
  xdialog -l char_set cell 1 $chr(9) +il 13 1 0 0
  xdialog -l char_set cell 1 $chr(9) +il 14 1 0 0
  xdialog -l char_set cell 1 $chr(9) +il 15 1 0 0
  xdialog -l char_set cell 1 $chr(9) +il 16 1 0 0
}


;===========================================================================================================================;
; menu carset | VxD ~ caronte.ade@gmail.com ~ www.vxd.altervista.org ~ vxd.altervista.org ~ http://vxd.altervista.org                    ;
;===========================================================================================================================;
alias fonts_set {
  dialog -ma fonts_set fonts_set_table
  /xdialog -b fonts_set -hmnsvxzo
  /xdialog -R fonts_set +s $dcx(GetSystemColor, COLOR_WINDOW)
  cla_car
  .timer 1 0 xdialog -l fonts_set update
}

dialog fonts_set_table {
  title "fonts_set"
  size %pos_or %pos_vr %pos_lr %pos_lu
}

on *:dialog:fonts_set:*:*: {
  if ($devent == init) {
    /dcx Mark $dname fonts_set_cb  
    /xdialog -V $dname %pos_or %pos_vr %pos_lr %pos_lu
    /xdialog -t $dname transparentcolor none
    /xdialog -t $dname alpha none
    /xdialog -g $dname +b $dcx(GetSystemColor, COLOR_WINDOW)
    /xdialog -T $dname +bp 
    /xdialog -t $dname bgcolor $dcx(GetSystemColor, COLOR_WINDOW)
    if (%cur_x == ON) /xdialog -q $dname +f %cursore 
    !if (!$dcx(IsUsingDirectX)) {
      /echo -a DirectX Is Disabled.
      halt
    }
    ;// Call initilisation alias
    fonts_set_init_dcx
  }
}

alias -l fonts_set_init_dcx {
  if (%position == left) { .timer 1 0 /xdock -m $dialog(fonts_set).hwnd +l | /xdialog -a $dname +so 100 }
  if (%position == right) { .timer 1 0 /xdock -m $dialog(fonts_set).hwnd +r | /xdialog -a $dname +sn 100 }
  if (%position == top) { .timer 1 0 /xdock -m $dialog(fonts_set).hwnd +t | /xdialog -a $dname +sv 100 }
  if (%position == bottom) { .timer 1 0 /xdock -m $dialog(fonts_set).hwnd +b |  /xdialog -a $dname +su 100 }
  carsetmenu 
}


;// Callback alias for fonts_set
alias fonts_set_cb {
  if ($2 != mouse) { ; echo $color(info) -s */ fonts_set_cb: $1- }
  if ($2 == sclick) {
    if ($3 == 1) { /set %xcartree Arial | .timer 1 0 refresh_car_list | ref_text | refont_text | xdialog -x fonts_set }
    elseif ($3 == 2) { /set %xcartree Comic Sans MS | .timer 1 0 refresh_car_list | ref_text | refont_text | xdialog -x fonts_set }
    elseif ($3 == 3) { /set %xcartree Consolas | .timer 1 0 refresh_car_list | ref_text | refont_text | xdialog -x fonts_set }
    elseif ($3 == 4) { /set %xcartree Calibri | .timer 1 0 refresh_car_list | ref_text | refont_text | xdialog -x fonts_set }
    elseif ($3 == 5) { /set %xcartree Courier New | .timer 1 0 refresh_car_list | ref_text | refont_text | xdialog -x fonts_set }
    elseif ($3 == 6) { /set %xcartree Fixedsys  | .timer 1 0 refresh_car_list | ref_text | refont_text | xdialog -x fonts_set }
    elseif ($3 == 7) { /set %xcartree Lucida Console | .timer 1 0 refresh_car_list | ref_text | refont_text | xdialog -x fonts_set }
    elseif ($3 == 8) { /set %xcartree Microsoft JhengHei | .timer 1 0 refresh_car_list | ref_text | refont_text | xdialog -x fonts_set }
    elseif ($3 == 9) { /set %xcartree Modern | .timer 1 0 refresh_car_list | refont_text | ref_text | xdialog -x fonts_set }
    elseif ($3 == 10) { /set %xcartree MS Sans Serif | .timer 1 0 refresh_car_list | ref_text | refont_text | xdialog -x fonts_set }
    elseif ($3 == 11) { /set %xcartree Script | .timer 1 0 refresh_car_list | ref_text | refont_text | xdialog -x fonts_set }
    elseif ($3 == 12) { /set %xcartree Segoe UI | .timer 1 0 refresh_car_list | ref_text | refont_text | xdialog -x fonts_set }
    elseif ($3 == 13) { /set %xcartree Thaoma | .timer 1 0 refresh_car_list | ref_text | refont_text | xdialog -x fonts_set }
    elseif ($3 == 14) { /set %xcartree Terminal | .timer 1 0 refresh_car_list | ref_text | refont_text | xdialog -x fonts_set }
    elseif ($3 == 15) { /set %xcartree Verdana | .timer 1 0 refresh_car_list | ref_text | refont_text | xdialog -x fonts_set }
    elseif ($3 == 16) { /set %xcartree Yu Gothic UI | .timer 1 0 refresh_car_list | ref_text | refont_text | xdialog -x fonts_set }
  }
}

alias refresh_car_list { 
  .timer 1 0 xdid -r treebardialog 3
  .timer 1 0 xdid -r treebardialog 4
  .timer 1 0 xdid -r treebardialog 5
  /xdid -E treebardialog 3 CharSet $+   %xchartree 
  /xdid -E treebardialog 4 FontName $+   %xcartree 
  /xdid -E treebardialog 5 Size $+   %xdimtree
}

alias carsetmenu {
  if ($xdialog(fonts_set, 1).isid == $true) /xdialog -d fonts_set 1
  if ($xdialog(fonts_set, 1).isid != $true) {
    ;// Initialising control: Arial (Text 1)
    xdialog -c fonts_set 1 text 2 0 200 40 tabstop default group tooltips bitmap shadow notheme transparent center 
    if (%lang == en) { xdid -t fonts_set 1 Arial | xdid -T fonts_set 1 Sets the font Arial } 
    if (%lang == it) { xdid -t fonts_set 1 Arial | xdid -T fonts_set 1 Imposta il carattere Arial }
    if (%lang == es) { xdid -t fonts_set 1 Arial | xdid -T fonts_set 1 Establecer el tipo de letra Arial }
    if (%lang == fr) { xdid -t fonts_set 1 Arial | xdid -T fonts_set 1 Réglez Arial }
    xdid -f fonts_set 1 %textmode Arial %xdimtree %xcartree
    xdid -C fonts_set 1 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C fonts_set 1 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J fonts_set 1 +f %butt
  }
  if ($xdialog(fonts_set, 2).isid == $true) /xdialog -d fonts_set 2
  if ($xdialog(fonts_set, 2).isid != $true) {
    ;// Initialising control: Comic Sans MS (Text 2)
    xdialog -c fonts_set 2 text 2 40 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t fonts_set 2 Comic Sans MS | xdid -T fonts_set 2 Sets the font Comic Sans MS } 
    if (%lang == it) { xdid -t fonts_set 2 Comic Sans MS | xdid -T fonts_set 2 Imposta il carattere Comic Sans MS }
    if (%lang == es) { xdid -t fonts_set 2 Comic Sans MS | xdid -T fonts_set 2 Establecer el tipo de letra Comic Sans MS }
    if (%lang == fr) { xdid -t fonts_set 2 Comic Sans MS | xdid -T fonts_set 2 Réglez Comic Sans MS }
    xdid -f fonts_set 2 %textmode Comic Sans MS %xdimtree %xcartree
    xdid -C fonts_set 2 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C fonts_set 2 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J fonts_set 2 +f %butt
  }
  if ($xdialog(fonts_set, 3).isid == $true) /xdialog -d fonts_set 3
  if ($xdialog(fonts_set, 3).isid != $true) {
    ;// Initialising control: Consolas (Text 3)
    xdialog -c fonts_set 3 text 2 80 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t fonts_set 3 Consolas | xdid -T fonts_set 3 Sets the font Consolas } 
    if (%lang == it) { xdid -t fonts_set 3 Consolas | xdid -T fonts_set 3 Imposta il carattere Consolas }
    if (%lang == es) { xdid -t fonts_set 3 Consolas | xdid -T fonts_set 3 Establecer el tipo de letra Consolas }
    if (%lang == fr) { xdid -t fonts_set 3 Consolas | xdid -T fonts_set 3 Réglez Consolas }
    xdid -f fonts_set 3 %textmode Consolas %xcartree %xdimtree %xcartree
    xdid -C fonts_set 3 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C fonts_set 3 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J fonts_set 3 +f %butt
  }
  if ($xdialog(fonts_set, 4).isid == $true) /xdialog -d fonts_set 4
  if ($xdialog(fonts_set, 4).isid != $true) {
    ;// Initialising control: Calibri (Text 4)
    xdialog -c fonts_set 4 text 2 120 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t fonts_set 4 Calibri | xdid -T fonts_set 4 Sets the font Calibri } 
    if (%lang == it) { xdid -t fonts_set 4 Calibri | xdid -T fonts_set 4 Imposta il carattere Calibri }
    if (%lang == es) { xdid -t fonts_set 4 Calibri | xdid -T fonts_set 4 Establecer el tipo de letra Calibri }
    if (%lang == fr) { xdid -t fonts_set 4 Calibri | xdid -T fonts_set 4 Réglez Calibri }
    xdid -f fonts_set 4 %textmode Calibri %xdimtree %xcartree
    xdid -C fonts_set 4 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C fonts_set 4 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J fonts_set 4 +f %butt
  }
  if ($xdialog(fonts_set, 5).isid == $true) /xdialog -d fonts_set 5
  if ($xdialog(fonts_set, 5).isid != $true) {
    ;// Initialising control: Courier New (Text 5)
    xdialog -c fonts_set 5 text 2 160 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t fonts_set 5 Courier New | xdid -T fonts_set 5 Sets the font Courier New } 
    if (%lang == it) { xdid -t fonts_set 5 Courier New | xdid -T fonts_set 5 Imposta il carattere Courier New }
    if (%lang == es) { xdid -t fonts_set 5 Courier New | xdid -T fonts_set 5 Establecer el tipo de letra Courier New }
    if (%lang == fr) { xdid -t fonts_set 5 Courier New | xdid -T fonts_set 5 Réglez Calibri }
    xdid -f fonts_set 5 %textmode Courier New %xdimtree %xcartree
    xdid -C fonts_set 5 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C fonts_set 5 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J fonts_set 5 +f %butt
  }
  if ($xdialog(fonts_set, 6).isid == $true) /xdialog -d fonts_set 6
  if ($xdialog(fonts_set, 6).isid != $true) {
    ;// Initialising control: Fixedsys (Text 6)
    xdialog -c fonts_set 6 text 2 200 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t fonts_set 6 Fixedsys | xdid -T fonts_set 6 Sets the font Fixedsys } 
    if (%lang == it) { xdid -t fonts_set 6 Fixedsys | xdid -T fonts_set 6 Imposta il carattere Fixedsys }
    if (%lang == es) { xdid -t fonts_set 6 Fixedsys | xdid -T fonts_set 6 Establecer el tipo de letra Fixedsys }
    if (%lang == fr) { xdid -t fonts_set 6 Fixedsys | xdid -T fonts_set 6 Réglez Fixedsys }
    xdid -f fonts_set 6 %textmode Fixedsys %xdimtree %xcartree
    xdid -C fonts_set 6 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C fonts_set 6 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J fonts_set 6 +f %butt
  }
  if ($xdialog(fonts_set, 7).isid == $true) /xdialog -d fonts_set 7
  if ($xdialog(fonts_set, 7).isid != $true) {
    ;// Initialising control: Lucida Console (Text 7)
    xdialog -c fonts_set 7 text 2 240 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t fonts_set 7 Lucida Console | xdid -T fonts_set 7 Sets the font Lucida Console } 
    if (%lang == it) { xdid -t fonts_set 7 Lucida Console | xdid -T fonts_set 7 Imposta il carattere Lucida Console }
    if (%lang == es) { xdid -t fonts_set 7 Lucida Console | xdid -T fonts_set 7 Establecer el tipo de letra Lucida Console }
    if (%lang == fr) { xdid -t fonts_set 7 Lucida Console | xdid -T fonts_set 7 Réglez Lucida Console }
    xdid -f fonts_set 7 %textmode Lucida Console %xdimtree %xcartree
    xdid -C fonts_set 7 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C fonts_set 7 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J fonts_set 7 +f %butt
  }
  if ($xdialog(fonts_set, 8).isid == $true) /xdialog -d fonts_set 8
  if ($xdialog(fonts_set, 8).isid != $true) {
    ;// Initialising control: Microsoft JhengHei (Text 8)
    xdialog -c fonts_set 8 text 2 280 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t fonts_set 8 Microsoft JhengHei | xdid -T fonts_set 8 Sets the font Microsoft JhengHei } 
    if (%lang == it) { xdid -t fonts_set 8 Microsoft JhengHei | xdid -T fonts_set 8 Imposta il carattere Microsoft JhengHei }
    if (%lang == es) { xdid -t fonts_set 8 Microsoft JhengHei | xdid -T fonts_set 8 Establecer el tipo de letra Microsoft JhengHei }
    if (%lang == fr) { xdid -t fonts_set 8 Microsoft JhengHei | xdid -T fonts_set 8 Réglez Microsoft JhengHei }
    xdid -f fonts_set 8 %textmode Microsoft JhengHei %xdimtree %xcartree
    xdid -C fonts_set 8 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C fonts_set 8 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J fonts_set 8 +f %butt
  }
  if ($xdialog(fonts_set, 9).isid == $true) /xdialog -d fonts_set 9
  if ($xdialog(fonts_set, 9).isid != $true) {
    ;// Initialising control: Modern (Text 9)
    xdialog -c fonts_set 9 text 2 320 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t fonts_set 9 Modern | xdid -T fonts_set 9 Sets the font Modern } 
    if (%lang == it) { xdid -t fonts_set 9 Modern | xdid -T fonts_set 9 Imposta il carattere Modern }
    if (%lang == es) { xdid -t fonts_set 9 Modern | xdid -T fonts_set 9 Establecer el tipo de letra Modern }
    if (%lang == fr) { xdid -t fonts_set 9 Modern | xdid -T fonts_set 9 Réglez Modern }
    xdid -f fonts_set 9 %textmode Modern %xdimtree %xcartree
    xdid -C fonts_set 9 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C fonts_set 9 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J fonts_set 9 +f %butt
  }
  if ($xdialog(fonts_set, 10).isid == $true) /xdialog -d fonts_set 10
  if ($xdialog(fonts_set, 10).isid != $true) {
    ;// Initialising control: MS Sans Serif (Text 10)
    xdialog -c fonts_set 10 text 2 360 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t fonts_set 10 MS Sans Serif | xdid -T fonts_set 10 Sets the font MS Sans Serif } 
    if (%lang == it) { xdid -t fonts_set 10 MS Sans Serif | xdid -T fonts_set 10 Imposta il carattere MS Sans Serif }
    if (%lang == es) { xdid -t fonts_set 10 MS Sans Serif | xdid -T fonts_set 10 Establecer el tipo de letra MS Sans Serif }
    if (%lang == fr) { xdid -t fonts_set 10 MS Sans Serif | xdid -T fonts_set 10 Réglez MS Sans Serif }
    xdid -f fonts_set 10 %textmode MS Sans Serif %xdimtree %xcartree
    xdid -C fonts_set 10 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C fonts_set 10 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J fonts_set 10 +f %butt
  }
  if ($xdialog(fonts_set, 11).isid == $true) /xdialog -d fonts_set 11
  if ($xdialog(fonts_set, 11).isid != $true) {
    ;// Initialising control: Script (Text 11)
    xdialog -c fonts_set 11 text 2 400 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t fonts_set 11 Script | xdid -T fonts_set 11 Sets the font Script } 
    if (%lang == it) { xdid -t fonts_set 11 Script | xdid -T fonts_set 11 Imposta il carattere Script }
    if (%lang == es) { xdid -t fonts_set 11 Script | xdid -T fonts_set 11 Establecer el tipo de letra Script }
    if (%lang == fr) { xdid -t fonts_set 11 Script | xdid -T fonts_set 11 Réglez Script }
    xdid -f fonts_set 11 %textmode Script %xdimtree %xcartree
    xdid -C fonts_set 11 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C fonts_set 11 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J fonts_set 11 +f %butt
  }
  if ($xdialog(fonts_set, 12).isid == $true) /xdialog -d fonts_set 12
  if ($xdialog(fonts_set, 12).isid != $true) {
    ;// Initialising control: Segoe UI (Text 12)
    xdialog -c fonts_set 12 text 2 440 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t fonts_set 12 Segoe UI | xdid -T fonts_set 12 Sets the font Segoe UI } 
    if (%lang == it) { xdid -t fonts_set 12 Segoe UI | xdid -T fonts_set 12 Imposta il carattere Segoe UI }
    if (%lang == es) { xdid -t fonts_set 12 Segoe UI | xdid -T fonts_set 12 Establecer el tipo de letra Segoe UI }
    if (%lang == fr) { xdid -t fonts_set 12 Segoe UI | xdid -T fonts_set 12 Réglez Segoe UI }
    xdid -f fonts_set 12 %textmode Segoe UI %xdimtree %xcartree
    xdid -C fonts_set 12 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C fonts_set 12 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J fonts_set 12 +f %butt
  }
  if ($xdialog(fonts_set, 13).isid == $true) /xdialog -d fonts_set 13
  if ($xdialog(fonts_set, 13).isid != $true) {
    ;// Initialising control: Thaoma (Text 13)
    xdialog -c fonts_set 13 text 2 480 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t fonts_set 13 Thaoma | xdid -T fonts_set 13 Sets the font Thaoma } 
    if (%lang == it) { xdid -t fonts_set 13 Thaoma | xdid -T fonts_set 13 Imposta il carattere Thaoma }
    if (%lang == es) { xdid -t fonts_set 13 Thaoma | xdid -T fonts_set 13 Establecer el tipo de letra Thaoma }
    if (%lang == fr) { xdid -t fonts_set 13 Thaoma | xdid -T fonts_set 13 Réglez Thaoma }
    xdid -f fonts_set 13 %textmode Thaoma %xdimtree %xcartree
    xdid -C fonts_set 13 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C fonts_set 13 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J fonts_set 13 +f %butt
  }
  if ($xdialog(fonts_set, 14).isid == $true) /xdialog -d fonts_set 14
  if ($xdialog(fonts_set, 14).isid != $true) {
    ;// Initialising control: Terminal (Text 14)
    xdialog -c fonts_set 14 text 2 520 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t fonts_set 14 Terminal | xdid -T fonts_set 14 Sets the font Terminal } 
    if (%lang == it) { xdid -t fonts_set 14 Terminal | xdid -T fonts_set 14 Imposta il carattere Terminal }
    if (%lang == es) { xdid -t fonts_set 14 Terminal | xdid -T fonts_set 14 Establecer el tipo de letra Terminal }
    if (%lang == fr) { xdid -t fonts_set 14 Terminal | xdid -T fonts_set 14 Réglez Terminal }
    xdid -f fonts_set 14 %textmode Terminal %xdimtree %xcartree
    xdid -C fonts_set 14 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C fonts_set 14 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J fonts_set 14 +f %butt
  }
  if ($xdialog(fonts_set, 15).isid == $true) /xdialog -d fonts_set 15
  if ($xdialog(fonts_set, 15).isid != $true) {
    ;// Initialising control: Verdana (Text 15)
    xdialog -c fonts_set 15 text 2 560 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t fonts_set 15 Verdana | xdid -T fonts_set 15 Sets the font Verdana } 
    if (%lang == it) { xdid -t fonts_set 15 Verdana | xdid -T fonts_set 15 Imposta il carattere Verdana }
    if (%lang == es) { xdid -t fonts_set 15 Verdana | xdid -T fonts_set 15 Establecer el tipo de letra Verdana }
    if (%lang == fr) { xdid -t fonts_set 15 Verdana | xdid -T fonts_set 15 Réglez Verdana }
    xdid -f fonts_set 15 %textmode Verdana %xdimtree %xcartree
    xdid -C fonts_set 15 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C fonts_set 15 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J fonts_set 15 +f %butt
  }
  if ($xdialog(fonts_set, 16).isid == $true) /xdialog -d fonts_set 16
  if ($xdialog(fonts_set, 16).isid != $true) {
    ;// Initialising control: Yu Gothic UI (Text 16)
    xdialog -c fonts_set 16 text 2 600 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t fonts_set 16 Yu Gothic UI | xdid -T fonts_set 16 Sets the font Yu Gothic UI } 
    if (%lang == it) { xdid -t fonts_set 16 Yu Gothic UI | xdid -T fonts_set 16 Imposta il carattere Yu Gothic UI }
    if (%lang == es) { xdid -t fonts_set 16 Yu Gothic UI | xdid -T fonts_set 16 Establecer el tipo de letra Yu Gothic UI }
    if (%lang == fr) { xdid -t fonts_set 16 Yu Gothic UI | xdid -T fonts_set 16 Réglez Yu Gothic UI }
    xdid -f fonts_set 16 %textmode Yu Gothic UI %xdimtree %xcartree
    xdid -C fonts_set 16 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C fonts_set 16 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J fonts_set 16 +f %butt
  }
}

alias cla_car {
  xdialog -l fonts_set root $chr(9) +plvh 0 0 0 0
  xdialog -l fonts_set cell root $chr(9) +pv 0 1 0 0
  xdialog -l fonts_set cell 1 $chr(9) +il 1 1 0 0
  xdialog -l fonts_set cell 1 $chr(9) +il 2 1 0 0
  xdialog -l fonts_set cell 1 $chr(9) +il 3 1 0 0
  xdialog -l fonts_set cell 1 $chr(9) +il 4 1 0 0
  xdialog -l fonts_set cell 1 $chr(9) +il 5 1 0 0
  xdialog -l fonts_set cell 1 $chr(9) +il 6 1 0 0
  xdialog -l fonts_set cell 1 $chr(9) +il 7 1 0 0
  xdialog -l fonts_set cell 1 $chr(9) +il 8 1 0 0
  xdialog -l fonts_set cell 1 $chr(9) +il 9 1 0 0
  xdialog -l fonts_set cell 1 $chr(9) +il 10 1 0 0
  xdialog -l fonts_set cell 1 $chr(9) +il 11 1 0 0
  xdialog -l fonts_set cell 1 $chr(9) +il 12 1 0 0
  xdialog -l fonts_set cell 1 $chr(9) +il 13 1 0 0
  xdialog -l fonts_set cell 1 $chr(9) +il 14 1 0 0
  xdialog -l fonts_set cell 1 $chr(9) +il 15 1 0 0
  xdialog -l fonts_set cell 1 $chr(9) +il 16 1 0 0
}

alias refont_text {
  if ($dialog(fonts_set) != $null) {
    xdid -f fonts_set 1 %textmode %xchartree %xdimtree Arial 
    xdid -f fonts_set 2 %textmode %xchartree %xdimtree Comic Sans MS 
    xdid -f fonts_set 3 %textmode %xchartree %xdimtree Consolas 
    xdid -f fonts_set 4 %textmode %xchartree %xdimtree Calibri 
    xdid -f fonts_set 5 %textmode %xchartree %xdimtree Courier New 
    xdid -f fonts_set 6 %textmode %xchartree %xdimtree Fixedsys 
    xdid -f fonts_set 7 %textmode %xchartree %xdimtree Lucida Console 
    xdid -f fonts_set 8 %textmode %xchartree %xdimtree Microsoft JhengHei 
    xdid -f fonts_set 9 %textmode %xchartree %xdimtree Modern 
    xdid -f fonts_set 10 %textmode %xchartree %xdimtree MS Sans Serif 
    xdid -f fonts_set 11 %textmode %xchartree %xdimtree Script 
    xdid -f fonts_set 12 %textmode %xchartree %xdimtree Segoe UI 
    xdid -f fonts_set 13 %textmode %xchartree %xdimtree Thaoma 
    xdid -f fonts_set 14 %textmode %xchartree %xdimtree Terminal 
    xdid -f fonts_set 15 %textmode %xchartree %xdimtree Verdana 
    xdid -f fonts_set 16 %textmode %xchartree %xdimtree Yu Gothic UI  
    .timer -m 1 1 xdialog -l fonts_set update
  }
}

;===========================================================================================================================;
; menu fonts size | VxD ~ caronte.ade@gmail.com ~ www.vxd.altervista.org ~ vxd.altervista.org ~ http://vxd.altervista.org                 ;
;===========================================================================================================================;
alias size_set {
  dialog -ma size_set size_set_table
  /xdialog -b size_set -hmnsvxzo
  /xdialog -R size_set +s $dcx(GetSystemColor, COLOR_WINDOW)
  size_cla_car
  .timer 1 0 xdialog -l size_set update
}

dialog size_set_table {
  title "size_set"
  size %pos_or %pos_vr %pos_lr %pos_lu
}

on *:dialog:size_set:*:*: {
  if ($devent == init) {
    /dcx Mark $dname size_set_cb  
    /xdialog -V $dname %pos_or %pos_vr %pos_lr %pos_lu
    /xdialog -t $dname transparentcolor none
    /xdialog -t $dname alpha none
    /xdialog -g $dname +b $dcx(GetSystemColor, COLOR_WINDOW)
    /xdialog -T $dname +bp 
    /xdialog -t $dname bgcolor $dcx(GetSystemColor, COLOR_WINDOW)
    if (%cur_x == ON) /xdialog -q $dname +f %cursore 
    !if (!$dcx(IsUsingDirectX)) {
      /echo -a DirectX Is Disabled.
      halt
    }
    ;// Call initilisation alias
    size_set_init_dcx
  }
}

alias -l size_set_init_dcx {
  if (%position == left) { .timer 1 0 /xdock -m $dialog(size_set).hwnd +l | /xdialog -a $dname +so 100 }
  if (%position == right) { .timer 1 0 /xdock -m $dialog(size_set).hwnd +r | /xdialog -a $dname +sn 100 }
  if (%position == top) { .timer 1 0 /xdock -m $dialog(size_set).hwnd +t | /xdialog -a $dname +sv 100 }
  if (%position == bottom) { .timer 1 0 /xdock -m $dialog(size_set).hwnd +b |  /xdialog -a $dname +su 100 }
  sizesetmenu 
}


;// Callback alias for size_set
alias size_set_cb {
  if ($2 != mouse) { ; echo $color(info) -s */ size_set_cb: $1- }
  if ($2 == sclick) {
    if ($3 == 1) { /set %xcartree 8 | .timer 1 0 refresh_size_list | ref_text | resize_text | xdialog -x size_set }
    elseif ($3 == 2) { /set %xdimtree 9 | .timer 1 0 refresh_size_list | ref_text | resize_text | xdialog -x size_set }
    elseif ($3 == 3) { /set %xdimtree 10 | .timer 1 0 refresh_size_list | ref_text | resize_text | xdialog -x size_set }
    elseif ($3 == 4) { /set %xdimtree 11 | .timer 1 0 refresh_size_list | ref_text | resize_text | xdialog -x size_set }
    elseif ($3 == 5) { /set %xdimtree 12 | .timer 1 0 refresh_size_list | ref_text | resize_text | xdialog -x size_set }
    elseif ($3 == 6) { /set %xdimtree 13 | .timer 1 0 refresh_size_list | ref_text | resize_text | xdialog -x size_set }
    elseif ($3 == 7) { /set %xdimtree 14 | .timer 1 0 refresh_size_list | ref_text | resize_text | xdialog -x size_set }
    elseif ($3 == 8) { /set %xdimtree 15 | .timer 1 0 refresh_size_list | ref_text | resize_text | xdialog -x size_set }
    elseif ($3 == 9) { /set %xdimtree 16 | .timer 1 0 refresh_size_list | ref_text | resize_text | xdialog -x size_set }
    elseif ($3 == 10) { /set %xdimtree 17 | .timer 1 0 refresh_size_list | ref_text | resize_text | xdialog -x size_set }
    elseif ($3 == 11) { /set %xdimtree 18 | .timer 1 0 refresh_size_list | ref_text | resize_text | xdialog -x size_set }
    elseif ($3 == 12) { /set %xdimtree 19 | .timer 1 0 refresh_size_list | ref_text | resize_text | xdialog -x size_set }
    elseif ($3 == 13) { /set %xdimtree 20 | .timer 1 0 refresh_size_list | ref_text | resize_text | xdialog -x size_set }
    elseif ($3 == 14) { /set %xdimtree 21 | .timer 1 0 refresh_size_list | ref_text | resize_text | xdialog -x size_set }
    elseif ($3 == 15) { /set %xdimtree 22 | .timer 1 0 refresh_size_list | ref_text | resize_text | xdialog -x size_set }
    elseif ($3 == 16) { /set %xdimtree 24 | .timer 1 0 refresh_size_list | ref_text | resize_text | xdialog -x size_set }
  }
}

alias refresh_size_list { 
  .timer 1 0 xdid -r treebardialog 3
  .timer 1 0 xdid -r treebardialog 4
  .timer 1 0 xdid -r treebardialog 5
  /xdid -E treebardialog 3 CharSet $+   %xchartree 
  /xdid -E treebardialog 4 FontName $+   %xcartree 
  /xdid -E treebardialog 5 Size $+   %xdimtree
}

alias sizesetmenu {
  if ($xdialog(size_set, 1).isid == $true) /xdialog -d size_set 1
  if ($xdialog(size_set, 1).isid != $true) {
    ;// Initialising control: Arial (Text 1)
    xdialog -c size_set 1 text 2 0 200 40 tabstop default group tooltips bitmap shadow notheme transparent center hidden
    if (%lang == en) { xdid -t size_set 1 ▄■▀ 8 | xdid -T size_set 1 Sets the font size ▄■▀ 8 } 
    if (%lang == it) { xdid -t size_set 1 ▄■▀ 8 | xdid -T size_set 1 Imposta la grandezza del carattere ▄■▀ 8 }
    if (%lang == es) { xdid -t size_set 1 ▄■▀ 8 | xdid -T size_set 1 Ajuste el tamaño de los caracteres ▄■▀ 8 }
    if (%lang == fr) { xdid -t size_set 1 ▄■▀ 8 | xdid -T size_set 1 Définissez la taille de caractères ▄■▀ 8 }
    xdid -f size_set 1 %textmode %xchartree 8 %xcartree
    xdid -C size_set 1 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C size_set 1 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J size_set 1 +f %butt
  }
  if ($xdialog(size_set, 2).isid == $true) /xdialog -d size_set 2
  if ($xdialog(size_set, 2).isid != $true) {
    ;// Initialising control: Comic Sans MS (Text 2)
    xdialog -c size_set 2 text 2 40 200 40 tabstop default group tooltips bitmap shadow notheme transparent center hidden
    if (%lang == en) { xdid -t size_set 2 ▄■▀ 9 | xdid -T size_set 2 Sets the font size ▄■▀ 9 } 
    if (%lang == it) { xdid -t size_set 2 ▄■▀ 9 | xdid -T size_set 2 Imposta la grandezza del carattere ▄■▀ 9 }
    if (%lang == es) { xdid -t size_set 2 ▄■▀ 9 | xdid -T size_set 2 Ajuste el tamaño de los caracteres ▄■▀ 9 }
    if (%lang == fr) { xdid -t size_set 2 ▄■▀ 9 | xdid -T size_set 2 Définissez la taille de caractères ▄■▀ 9 }
    xdid -f size_set 2 %textmode %xchartree 9 %xcartree
    xdid -C size_set 2 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C size_set 2 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J size_set 2 +f %butt
  }
  if ($xdialog(size_set, 3).isid == $true) /xdialog -d size_set 3
  if ($xdialog(size_set, 3).isid != $true) {
    ;// Initialising control: Consolas (Text 3)
    xdialog -c size_set 3 text 2 80 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t size_set 3 ▄■▀ 10 | xdid -T size_set 3 Sets the font size ▄■▀ 10 } 
    if (%lang == it) { xdid -t size_set 3 ▄■▀ 10 | xdid -T size_set 3 Imposta la grandezza del carattere ▄■▀ 10 }
    if (%lang == es) { xdid -t size_set 3 ▄■▀ 10 | xdid -T size_set 3 Ajuste el tamaño de los caracteres ▄■▀ 10 }
    if (%lang == fr) { xdid -t size_set 3 ▄■▀ 10 | xdid -T size_set 3 Définissez la taille de caractères ▄■▀ 10 }
    xdid -f size_set 3 %textmode %xchartree 10 %xcartree
    xdid -C size_set 3 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C size_set 3 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J size_set 3 +f %butt
  }
  if ($xdialog(size_set, 4).isid == $true) /xdialog -d size_set 4
  if ($xdialog(size_set, 4).isid != $true) {
    ;// Initialising control: Calibri (Text 4)
    xdialog -c size_set 4 text 2 120 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t size_set 4 ▄■▀ 11 | xdid -T size_set 4 Sets the font size ▄■▀ 11 } 
    if (%lang == it) { xdid -t size_set 4 ▄■▀ 11 | xdid -T size_set 4 Imposta la grandezza del carattere ▄■▀ 11 }
    if (%lang == es) { xdid -t size_set 4 ▄■▀ 11 | xdid -T size_set 4 Ajuste el tamaño de los caracteres ▄■▀ 11 }
    if (%lang == fr) { xdid -t size_set 4 ▄■▀ 11 | xdid -T size_set 4 Définissez la taille de caractères ▄■▀ 11 }
    xdid -f size_set 4 %textmode %xchartree 11 %xcartree
    xdid -C size_set 4 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C size_set 4 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J size_set 4 +f %butt
  }
  if ($xdialog(size_set, 5).isid == $true) /xdialog -d size_set 5
  if ($xdialog(size_set, 5).isid != $true) {
    ;// Initialising control: Courier New (Text 5)
    xdialog -c size_set 5 text 2 160 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t size_set 5 ▄■▀ 12 | xdid -T size_set 5 Sets the font size ▄■▀ 12 } 
    if (%lang == it) { xdid -t size_set 5 ▄■▀ 12 | xdid -T size_set 5 Imposta la grandezza del carattere ▄■▀ 12 }
    if (%lang == es) { xdid -t size_set 5 ▄■▀ 12 | xdid -T size_set 5 Ajuste el tamaño de los caracteres ▄■▀ 12 }
    if (%lang == fr) { xdid -t size_set 5 ▄■▀ 12 | xdid -T size_set 5 Définissez la taille de caractères ▄■▀ 12 }
    xdid -f size_set 5 %textmode %xchartree 12 %xcartree
    xdid -C size_set 5 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C size_set 5 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J size_set 5 +f %butt
  }
  if ($xdialog(size_set, 6).isid == $true) /xdialog -d size_set 6
  if ($xdialog(size_set, 6).isid != $true) {
    ;// Initialising control: Fixedsys (Text 6)
    xdialog -c size_set 6 text 2 200 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t size_set 6 ▄■▀ 13 | xdid -T size_set 6 Sets the font size ▄■▀ 13 } 
    if (%lang == it) { xdid -t size_set 6 ▄■▀ 13 | xdid -T size_set 6 Imposta la grandezza del carattere ▄■▀ 13 }
    if (%lang == es) { xdid -t size_set 6 ▄■▀ 13 | xdid -T size_set 6 Ajuste el tamaño de los caracteres ▄■▀ 13 }
    if (%lang == fr) { xdid -t size_set 6 ▄■▀ 13 | xdid -T size_set 6 Définissez la taille de caractères ▄■▀ 13 }
    xdid -f size_set 6 %textmode %xchartree 13 %xcartree
    xdid -C size_set 6 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C size_set 6 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J size_set 6 +f %butt
  }
  if ($xdialog(size_set, 7).isid == $true) /xdialog -d size_set 7
  if ($xdialog(size_set, 7).isid != $true) {
    ;// Initialising control: Lucida Console (Text 7)
    xdialog -c size_set 7 text 2 240 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t size_set 7 ▄■▀ 14 | xdid -T size_set 7 Sets the font size ▄■▀ 14 } 
    if (%lang == it) { xdid -t size_set 7 ▄■▀ 14 | xdid -T size_set 7 Imposta la grandezza del carattere ▄■▀ 14 }
    if (%lang == es) { xdid -t size_set 7 ▄■▀ 14 | xdid -T size_set 7 Ajuste el tamaño de los caracteres ▄■▀ 14 }
    if (%lang == fr) { xdid -t size_set 7 ▄■▀ 14 | xdid -T size_set 7 Définissez la taille de caractères ▄■▀ 14 }
    xdid -f size_set 7 %textmode %xchartree 14 %xcartree
    xdid -C size_set 7 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C size_set 7 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J size_set 7 +f %butt
  }
  if ($xdialog(size_set, 8).isid == $true) /xdialog -d size_set 8
  if ($xdialog(size_set, 8).isid != $true) {
    ;// Initialising control: Microsoft JhengHei (Text 8)
    xdialog -c size_set 8 text 2 280 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t size_set 8 ▄■▀ 15 | xdid -T size_set 8 Sets the font size ▄■▀ 15 } 
    if (%lang == it) { xdid -t size_set 8 ▄■▀ 15 | xdid -T size_set 8 Imposta la grandezza del carattere ▄■▀ 15 }
    if (%lang == es) { xdid -t size_set 8 ▄■▀ 15 | xdid -T size_set 8 Ajuste el tamaño de los caracteres ▄■▀ 15 }
    if (%lang == fr) { xdid -t size_set 8 ▄■▀ 15 | xdid -T size_set 8 Définissez la taille de caractères ▄■▀ 15 }
    xdid -f size_set 8 %textmode %xchartree 15 %xcartree
    xdid -C size_set 8 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C size_set 8 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J size_set 8 +f %butt
  }
  if ($xdialog(size_set, 9).isid == $true) /xdialog -d size_set 9
  if ($xdialog(size_set, 9).isid != $true) {
    ;// Initialising control: Modern (Text 9)
    xdialog -c size_set 9 text 2 320 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t size_set 9 ▄■▀ 16 | xdid -T size_set 9 Sets the font size ▄■▀ 16 } 
    if (%lang == it) { xdid -t size_set 9 ▄■▀ 16 | xdid -T size_set 9 Imposta la grandezza del carattere ▄■▀ 16 }
    if (%lang == es) { xdid -t size_set 9 ▄■▀ 16 | xdid -T size_set 9 Ajuste el tamaño de los caracteres ▄■▀ 16 }
    if (%lang == fr) { xdid -t size_set 9 ▄■▀ 16 | xdid -T size_set 9 Définissez la taille de caractères ▄■▀ 16 }
    xdid -f size_set 9 %textmode %xchartree 16 %xcartree
    xdid -C size_set 9 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C size_set 9 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J size_set 9 +f %butt
  }
  if ($xdialog(size_set, 10).isid == $true) /xdialog -d size_set 10
  if ($xdialog(size_set, 10).isid != $true) {
    ;// Initialising control: MS Sans Serif (Text 10)
    xdialog -c size_set 10 text 2 360 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t size_set 10 ▄■▀ 17 | xdid -T size_set 10 Sets the font size ▄■▀ 17 } 
    if (%lang == it) { xdid -t size_set 10 ▄■▀ 17 | xdid -T size_set 10 Imposta la grandezza del carattere ▄■▀ 17 }
    if (%lang == es) { xdid -t size_set 10 ▄■▀ 17 | xdid -T size_set 10 Ajuste el tamaño de los caracteres ▄■▀ 17 }
    if (%lang == fr) { xdid -t size_set 10 ▄■▀ 17 | xdid -T size_set 10 Définissez la taille de caractères ▄■▀ 17 }
    xdid -f size_set 10 %textmode %xchartree 17 %xcartree
    xdid -C size_set 10 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C size_set 10 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J size_set 10 +f %butt
  }
  if ($xdialog(size_set, 11).isid == $true) /xdialog -d size_set 11
  if ($xdialog(size_set, 11).isid != $true) {
    ;// Initialising control: Script (Text 11)
    xdialog -c size_set 11 text 2 400 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t size_set 11 ▄■▀ 18 | xdid -T size_set 11 Sets the font size ▄■▀ 18 } 
    if (%lang == it) { xdid -t size_set 11 ▄■▀ 18 | xdid -T size_set 11 Imposta la grandezza del carattere ▄■▀ 18 }
    if (%lang == es) { xdid -t size_set 11 ▄■▀ 18 | xdid -T size_set 11 Ajuste el tamaño de los caracteres ▄■▀ 18 }
    if (%lang == fr) { xdid -t size_set 11 ▄■▀ 18 | xdid -T size_set 11 Définissez la taille de caractères ▄■▀ 18 }
    xdid -f size_set 11 %textmode %xchartree 18 %xcartree
    xdid -C size_set 11 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C size_set 11 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J size_set 11 +f %butt
  }
  if ($xdialog(size_set, 12).isid == $true) /xdialog -d size_set 12
  if ($xdialog(size_set, 12).isid != $true) {
    ;// Initialising control: Segoe UI (Text 12)
    xdialog -c size_set 12 text 2 440 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t size_set 12 ▄■▀ 19 | xdid -T size_set 12 Sets the font size ▄■▀ 19 } 
    if (%lang == it) { xdid -t size_set 12 ▄■▀ 19 | xdid -T size_set 12 Imposta la grandezza del carattere ▄■▀ 19 }
    if (%lang == es) { xdid -t size_set 12 ▄■▀ 19 | xdid -T size_set 12 Ajuste el tamaño de los caracteres ▄■▀ 19 }
    if (%lang == fr) { xdid -t size_set 12 ▄■▀ 19 | xdid -T size_set 12 Définissez la taille de caractères ▄■▀ 19 }
    xdid -f size_set 12 %textmode %xchartree 19 %xcartree
    xdid -C size_set 12 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C size_set 12 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J size_set 12 +f %butt
  }
  if ($xdialog(size_set, 13).isid == $true) /xdialog -d size_set 13
  if ($xdialog(size_set, 13).isid != $true) {
    ;// Initialising control: Thaoma (Text 13)
    xdialog -c size_set 13 text 2 480 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t size_set 13 ▄■▀ 20 | xdid -T size_set 13 Sets the font size ▄■▀ 20 } 
    if (%lang == it) { xdid -t size_set 13 ▄■▀ 20 | xdid -T size_set 13 Imposta la grandezza del carattere ▄■▀ 20 }
    if (%lang == es) { xdid -t size_set 13 ▄■▀ 20 | xdid -T size_set 13 Ajuste el tamaño de los caracteres ▄■▀ 20 }
    if (%lang == fr) { xdid -t size_set 13 ▄■▀ 20 | xdid -T size_set 13 Définissez la taille de caractères ▄■▀ 20 }
    xdid -f size_set 13 %textmode %xchartree 20 %xcartree
    xdid -C size_set 13 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C size_set 13 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J size_set 13 +f %butt
  }
  if ($xdialog(size_set, 14).isid == $true) /xdialog -d size_set 14
  if ($xdialog(size_set, 14).isid != $true) {
    ;// Initialising control: Terminal (Text 14)
    xdialog -c size_set 14 text 2 520 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t size_set 14 ▄■▀ 21 | xdid -T size_set 14 Sets the font size ▄■▀ 21 } 
    if (%lang == it) { xdid -t size_set 14 ▄■▀ 21 | xdid -T size_set 14 Imposta la grandezza del carattere ▄■▀ 21 }
    if (%lang == es) { xdid -t size_set 14 ▄■▀ 21 | xdid -T size_set 14 Ajuste el tamaño de los caracteres ▄■▀ 21 }
    if (%lang == fr) { xdid -t size_set 14 ▄■▀ 21 | xdid -T size_set 14 Définissez la taille de caractères ▄■▀ 21 }
    xdid -f size_set 14 %textmode %xchartree 21 %xcartree
    xdid -C size_set 14 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C size_set 14 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J size_set 14 +f %butt
  }
  if ($xdialog(size_set, 15).isid == $true) /xdialog -d size_set 15
  if ($xdialog(size_set, 15).isid != $true) {
    ;// Initialising control: Verdana (Text 15)
    xdialog -c size_set 15 text 2 560 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t size_set 15 ▄■▀ 22 | xdid -T size_set 15 Sets the font size ▄■▀ 22 } 
    if (%lang == it) { xdid -t size_set 15 ▄■▀ 22 | xdid -T size_set 15 Imposta la grandezza del carattere ▄■▀ 22 }
    if (%lang == es) { xdid -t size_set 15 ▄■▀ 22 | xdid -T size_set 15 Ajuste el tamaño de los caracteres ▄■▀ 22 }
    if (%lang == fr) { xdid -t size_set 15 ▄■▀ 22 | xdid -T size_set 15 Définissez la taille de caractères ▄■▀ 22 }
    xdid -f size_set 15 %textmode %xchartree 22 %xcartree
    xdid -C size_set 15 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C size_set 15 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J size_set 15 +f %butt
  }
  if ($xdialog(size_set, 16).isid == $true) /xdialog -d size_set 16
  if ($xdialog(size_set, 16).isid != $true) {
    ;// Initialising control: Yu Gothic UI (Text 16)
    xdialog -c size_set 16 text 2 600 200 40 tabstop default group tooltips bitmap shadow notheme transparent center
    if (%lang == en) { xdid -t size_set 16 ▄■▀ 24 | xdid -T size_set 16 Sets the font size ▄■▀ 24 } 
    if (%lang == it) { xdid -t size_set 16 ▄■▀ 24 | xdid -T size_set 16 Imposta la grandezza del carattere ▄■▀ 24 }
    if (%lang == es) { xdid -t size_set 16 ▄■▀ 24 | xdid -T size_set 16 Ajuste el tamaño de los caracteres ▄■▀ 24 }
    if (%lang == fr) { xdid -t size_set 16 ▄■▀ 24 | xdid -T size_set 16 Définissez la taille de caractères ▄■▀ 24 }
    xdid -f size_set 16 %textmode %xchartree 24 %xcartree
    xdid -C size_set 16 +bk $dcx(GetSystemColor, COLOR_WINDOW)
    xdid -C size_set 16 +t $dcx(GetSystemColor, COLOR_WINDOWTEXT)
    if (%cur_x == ON) xdid -J size_set 16 +f %butt
  }
}

alias size_cla_car {
  xdialog -l size_set root $chr(9) +plvh 0 0 0 0
  xdialog -l size_set cell root $chr(9) +pv 0 1 0 0
  xdialog -l size_set cell 1 $chr(9) +il 1 1 0 0
  xdialog -l size_set cell 1 $chr(9) +il 2 1 0 0
  xdialog -l size_set cell 1 $chr(9) +il 3 1 0 0
  xdialog -l size_set cell 1 $chr(9) +il 4 1 0 0
  xdialog -l size_set cell 1 $chr(9) +il 5 1 0 0
  xdialog -l size_set cell 1 $chr(9) +il 6 1 0 0
  xdialog -l size_set cell 1 $chr(9) +il 7 1 0 0
  xdialog -l size_set cell 1 $chr(9) +il 8 1 0 0
  xdialog -l size_set cell 1 $chr(9) +il 9 1 0 0
  xdialog -l size_set cell 1 $chr(9) +il 10 1 0 0
  xdialog -l size_set cell 1 $chr(9) +il 11 1 0 0
  xdialog -l size_set cell 1 $chr(9) +il 12 1 0 0
  xdialog -l size_set cell 1 $chr(9) +il 13 1 0 0
  xdialog -l size_set cell 1 $chr(9) +il 14 1 0 0
  xdialog -l size_set cell 1 $chr(9) +il 15 1 0 0
  xdialog -l size_set cell 1 $chr(9) +il 16 1 0 0
}

alias resize_text {
  if ($dialog(size_set) != $null) {
    xdid -f size_set 1 %textmode %xchartree 8 %xcartree    
    xdid -f size_set 2 %textmode %xchartree 9 %xcartree
    xdid -f size_set 3 %textmode %xchartree 10 %xcartree
    xdid -f size_set 4 %textmode %xchartree 11 %xcartree
    xdid -f size_set 5 %textmode %xchartree 12 %xcartree
    xdid -f size_set 6 %textmode %xchartree 13 %xcartree
    xdid -f size_set 7 %textmode %xchartree 14 %xcartree
    xdid -f size_set 8 %textmode %xchartree 15 %xcartree
    xdid -f size_set 9 %textmode %xchartree 16 %xcartree
    xdid -f size_set 10 %textmode %xchartree 17 %xcartree
    xdid -f size_set 11 %textmode %xchartree 18 %xcartree
    xdid -f size_set 12 %textmode %xchartree 19 %xcartree
    xdid -f size_set 13 %textmode %xchartree 20 %xcartree
    xdid -f size_set 14 %textmode %xchartree 21 %xcartree
    xdid -f size_set 15 %textmode %xchartree 22 %xcartree
    xdid -f size_set 16 %textmode %xchartree 24 %xcartree 
    .timer -m 1 1 xdialog -l size_set update
  }
}
